/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.mongo.tools;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.Validate;
import org.bson.types.BSONTimestamp;
import org.mule.module.mongo.api.MongoClient;
import org.mule.module.mongo.tools.AbstractMongoUtility;
import org.mule.module.mongo.tools.BackupUtils;
import org.mule.module.mongo.tools.BsonDumpWriter;
import org.mule.module.mongo.tools.MongoDumpCollection;
import org.mule.module.mongo.tools.OplogCollection;
import org.mule.module.mongo.tools.ZipUtils;

public class MongoDump
extends AbstractMongoUtility {
    public static final String TIMESTAMP_FORMAT = "'.'yyyy-MM-dd-HH-mm";
    private final MongoClient mongoClient;
    private boolean zip;
    private boolean oplog;
    private final Map<String, DB> dbs = new HashMap<String, DB>();
    private DBCollection oplogCollection;
    private BSONTimestamp oplogStart;

    public MongoDump(MongoClient mongoClient) {
        this.mongoClient = mongoClient;
    }

    public void dump(String outputDirectory, String database, String outputName, int threads) throws IOException {
        Validate.notNull((Object)outputDirectory);
        Validate.notNull((Object)outputName);
        Validate.notNull((Object)database);
        String opName = outputName;
        opName = opName + this.appendTimestamp();
        this.initOplog(database);
        Collection<String> collections = this.mongoClient.listCollections();
        if (collections != null) {
            ExecutorService executor = Executors.newFixedThreadPool(threads);
            BsonDumpWriter dumpWriter = new BsonDumpWriter(outputDirectory, opName);
            for (String collectionName : collections) {
                DBCollection dbCollection = this.mongoClient.getCollection(collectionName);
                MongoDumpCollection dumpCollection = new MongoDumpCollection(dbCollection);
                dumpCollection.setDumpWriter(dumpWriter);
                Future<Void> future = executor.submit(dumpCollection);
                this.propagateException(future);
            }
            executor.shutdown();
            try {
                if (!executor.awaitTermination(60L, TimeUnit.SECONDS)) {
                    executor.shutdownNow();
                }
                if (this.oplog) {
                    ExecutorService singleExecutor = Executors.newSingleThreadExecutor();
                    MongoDumpCollection dumpCollection = new MongoDumpCollection(this.oplogCollection);
                    dumpCollection.setName("oplog");
                    dumpCollection.addOption(8);
                    dumpCollection.addOption(4);
                    BasicDBObject query = new BasicDBObject();
                    query.put("ts", (Object)new BasicDBObject("$gt", (Object)this.oplogStart));
                    query.put("ns", (Object)BackupUtils.getNamespacePattern(database));
                    dumpCollection.setQuery((DBObject)query);
                    dumpCollection.setDumpWriter(dumpWriter);
                    Future<Void> future = singleExecutor.submit(dumpCollection);
                    this.propagateException(future);
                }
                if (this.zip) {
                    String dbDumpPath = outputDirectory + File.separator + opName;
                    ZipUtils.zipDirectory(dbDumpPath);
                    FileUtils.deleteDirectory((File)new File(dbDumpPath));
                }
            }
            catch (InterruptedException ie) {
                executor.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    private void initOplog(String database) throws IOException {
        if (this.oplog) {
            this.oplogCollection = new OplogCollection(this.dbs.get("admin"), this.dbs.get("local")).getOplogCollection();
            BasicDBObject query = new BasicDBObject("ns", (Object)BackupUtils.getNamespacePattern(database));
            DBCursor oplogCursor = this.oplogCollection.find((DBObject)query);
            oplogCursor.sort((DBObject)new BasicDBObject("$natural", (Object)-1));
            if (oplogCursor.hasNext()) {
                this.oplogStart = (BSONTimestamp)oplogCursor.next().get("ts");
            }
        }
    }

    private String appendTimestamp() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(TIMESTAMP_FORMAT);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat.format(new Date());
    }

    public void setZip(boolean zip) {
        this.zip = zip;
    }

    public void setOplog(boolean oplog) {
        this.oplog = oplog;
    }

    public void addDB(DB db) {
        this.dbs.put(db.getName(), db);
    }
}

