/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.mongo.tools;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import org.apache.commons.lang.Validate;
import org.bson.types.BSONTimestamp;
import org.mule.module.mongo.tools.BackupUtils;
import org.mule.module.mongo.tools.BsonDumpWriter;
import org.mule.module.mongo.tools.DumpWriter;
import org.mule.module.mongo.tools.OplogCollection;

public class IncrementalOplogDump
implements Callable<Void> {
    private static final String INCREMENTAL_LAST_TIMESTAMP = "incremental_last_timestamp.txt";
    private Map<String, DB> dbs = new HashMap<String, DB>();
    private String incrementalTimestampFile;
    private String outputDirectory;
    private String database;

    @Override
    public Void call() throws Exception {
        this.dump(this.outputDirectory, this.database);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dump(String outputDirectory, String database) throws IOException {
        DBCursor oplogCursor;
        Validate.notNull((Object)outputDirectory);
        Validate.notNull((Object)database);
        String incrementalFilePath = this.incrementalTimestampFile != null ? this.incrementalTimestampFile : outputDirectory + File.separator + INCREMENTAL_LAST_TIMESTAMP;
        BSONTimestamp lastTimestamp = this.getLastTimestamp(incrementalFilePath);
        DBCollection oplogCollection = new OplogCollection(this.dbs.get("admin"), this.dbs.get("local")).getOplogCollection();
        if (lastTimestamp != null) {
            BasicDBObject query = new BasicDBObject();
            query.put("ts", (Object)new BasicDBObject("$gt", (Object)lastTimestamp));
            query.put("ns", (Object)BackupUtils.getNamespacePattern(database));
            oplogCursor = oplogCollection.find((DBObject)query);
            oplogCursor.addOption(8);
        } else {
            oplogCursor = oplogCollection.find();
        }
        BsonDumpWriter dumpWriter = new BsonDumpWriter(outputDirectory);
        String oplogCollectionTimestamp = "oplog" + this.appendTimestamp();
        try {
            while (oplogCursor.hasNext()) {
                DBObject oplogEntry = oplogCursor.next();
                lastTimestamp = (BSONTimestamp)oplogEntry.get("ts");
                ((DumpWriter)dumpWriter).writeObject(oplogCollectionTimestamp, oplogEntry);
            }
        }
        finally {
            this.writeLastTimestamp(incrementalFilePath, lastTimestamp);
        }
    }

    private BSONTimestamp getLastTimestamp(String incrementalFilePath) throws IOException {
        File incrementalFile = new File(incrementalFilePath);
        if (!incrementalFile.exists()) {
            return null;
        }
        BufferedReader input = null;
        try {
            input = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(incrementalFile), "UTF-8"));
            String line = input.readLine();
            String[] parts = line.split("\\|");
            BSONTimestamp bSONTimestamp = new BSONTimestamp(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]));
            return bSONTimestamp;
        }
        catch (NullPointerException ne) {
            throw new RuntimeException(ne.getMessage(), ne);
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLastTimestamp(String incrementalFilePath, BSONTimestamp lastTimestamp) throws IOException {
        if (lastTimestamp != null) {
            Writer writer = null;
            try {
                FileOutputStream outputStream = new FileOutputStream(new File(incrementalFilePath));
                writer = new OutputStreamWriter((OutputStream)outputStream, "UTF-8");
                writer.write(lastTimestamp.getTime() + "|" + lastTimestamp.getInc());
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
    }

    private String appendTimestamp() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("'.'yyyy-MM-dd-HH-mm");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat.format(new Date());
    }

    public void setDBs(Map<String, DB> dbs) {
        this.dbs.putAll(dbs);
    }

    public void setIncrementalTimestampFile(String incrementalTimestampFile) {
        this.incrementalTimestampFile = incrementalTimestampFile;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setDatabase(String database) {
        this.database = database;
    }
}

