/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.mongo.connectivity;

import org.apache.commons.pool.KeyedObjectPool;
import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.mule.api.MetadataAware;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.MuleContextAware;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.devkit.capability.Capabilities;
import org.mule.api.devkit.capability.ModuleCapability;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.common.DefaultResult;
import org.mule.common.DefaultTestResult;
import org.mule.common.FailureType;
import org.mule.common.Result;
import org.mule.common.TestResult;
import org.mule.common.Testable;
import org.mule.config.PoolingProfile;
import org.mule.devkit.processor.ExpressionEvaluatorSupport;
import org.mule.module.mongo.adapters.MongoCloudConnectorConnectionIdentifierAdapter;
import org.mule.module.mongo.connection.ConnectionManager;
import org.mule.module.mongo.connection.UnableToAcquireConnectionException;
import org.mule.module.mongo.connectivity.MongoCloudConnectorConnectionFactory;
import org.mule.module.mongo.connectivity.MongoCloudConnectorConnectionKey;
import org.mule.module.mongo.connectivity.MongoCloudConnectorManagedConnectionProcessTemplate;
import org.mule.module.mongo.pooling.DevkitGenericKeyedObjectPool;

public class MongoCloudConnectorConnectionManager
extends ExpressionEvaluatorSupport
implements MetadataAware,
MuleContextAware,
ProcessAdapter<MongoCloudConnectorConnectionIdentifierAdapter>,
Capabilities,
Disposable,
Initialisable,
Testable,
ConnectionManager<MongoCloudConnectorConnectionKey, MongoCloudConnectorConnectionIdentifierAdapter> {
    private String username;
    private String password;
    private String database;
    private String host;
    private int port;
    private Integer connectionsPerHost;
    private Integer threadsAllowedToBlockForConnectionMultiplier;
    private Integer maxWaitTime;
    private Integer connectTimeout;
    private Integer socketTimeout;
    private Boolean autoConnectRetry;
    protected MuleContext muleContext;
    protected FlowConstruct flowConstruct;
    private KeyedObjectPool connectionPool;
    protected PoolingProfile poolingProfile;
    protected RetryPolicyTemplate retryPolicyTemplate;
    private static final String MODULE_NAME = "Mongo DB";
    private static final String MODULE_VERSION = "3.6.1";
    private static final String DEVKIT_VERSION = "3.5.2";
    private static final String DEVKIT_BUILD = "UNNAMED.2039.0541b23";
    private static final String MIN_MULE_VERSION = "3.5";

    public void setHost(String value) {
        this.host = value;
    }

    public String getHost() {
        return this.host;
    }

    public void setPort(int value) {
        this.port = value;
    }

    public int getPort() {
        return this.port;
    }

    public void setConnectionsPerHost(Integer value) {
        this.connectionsPerHost = value;
    }

    public Integer getConnectionsPerHost() {
        return this.connectionsPerHost;
    }

    public void setThreadsAllowedToBlockForConnectionMultiplier(Integer value) {
        this.threadsAllowedToBlockForConnectionMultiplier = value;
    }

    public Integer getThreadsAllowedToBlockForConnectionMultiplier() {
        return this.threadsAllowedToBlockForConnectionMultiplier;
    }

    public void setMaxWaitTime(Integer value) {
        this.maxWaitTime = value;
    }

    public Integer getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public void setConnectTimeout(Integer value) {
        this.connectTimeout = value;
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setSocketTimeout(Integer value) {
        this.socketTimeout = value;
    }

    public Integer getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setAutoConnectRetry(Boolean value) {
        this.autoConnectRetry = value;
    }

    public Boolean getAutoConnectRetry() {
        return this.autoConnectRetry;
    }

    public void setMuleContext(MuleContext value) {
        this.muleContext = value;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public void setFlowConstruct(FlowConstruct value) {
        this.flowConstruct = value;
    }

    public FlowConstruct getFlowConstruct() {
        return this.flowConstruct;
    }

    public void setPoolingProfile(PoolingProfile value) {
        this.poolingProfile = value;
    }

    public PoolingProfile getPoolingProfile() {
        return this.poolingProfile;
    }

    public void setRetryPolicyTemplate(RetryPolicyTemplate value) {
        this.retryPolicyTemplate = value;
    }

    @Override
    public RetryPolicyTemplate getRetryPolicyTemplate() {
        return this.retryPolicyTemplate;
    }

    public void setUsername(String value) {
        this.username = value;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String value) {
        this.password = value;
    }

    public String getPassword() {
        return this.password;
    }

    public void setDatabase(String value) {
        this.database = value;
    }

    public String getDatabase() {
        return this.database;
    }

    public void initialise() {
        this.connectionPool = new DevkitGenericKeyedObjectPool(new MongoCloudConnectorConnectionFactory(this), this.poolingProfile);
        if (this.retryPolicyTemplate == null) {
            this.retryPolicyTemplate = (RetryPolicyTemplate)this.muleContext.getRegistry().lookupObject("_defaultRetryPolicyTemplate");
        }
    }

    public void dispose() {
        try {
            this.connectionPool.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public MongoCloudConnectorConnectionIdentifierAdapter acquireConnection(MongoCloudConnectorConnectionKey key) throws Exception {
        return (MongoCloudConnectorConnectionIdentifierAdapter)this.connectionPool.borrowObject((Object)key);
    }

    @Override
    public void releaseConnection(MongoCloudConnectorConnectionKey key, MongoCloudConnectorConnectionIdentifierAdapter connection) throws Exception {
        this.connectionPool.returnObject((Object)key, (Object)connection);
    }

    @Override
    public void destroyConnection(MongoCloudConnectorConnectionKey key, MongoCloudConnectorConnectionIdentifierAdapter connection) throws Exception {
        this.connectionPool.invalidateObject((Object)key, (Object)connection);
    }

    public boolean isCapableOf(ModuleCapability capability) {
        if (capability == ModuleCapability.LIFECYCLE_CAPABLE) {
            return true;
        }
        return capability == ModuleCapability.CONNECTION_MANAGEMENT_CAPABLE;
    }

    public <P> ProcessTemplate<P, MongoCloudConnectorConnectionIdentifierAdapter> getProcessTemplate() {
        return new MongoCloudConnectorManagedConnectionProcessTemplate(this, this.muleContext);
    }

    @Override
    public MongoCloudConnectorConnectionKey getDefaultConnectionKey() {
        return new MongoCloudConnectorConnectionKey(this.getUsername(), this.getPassword(), this.getDatabase());
    }

    @Override
    public MongoCloudConnectorConnectionKey getEvaluatedConnectionKey(MuleEvent event) throws Exception {
        if (event != null) {
            String _transformedUsername = (String)this.evaluateAndTransform(this.muleContext, event, this.getClass().getDeclaredField("username").getGenericType(), null, this.getUsername());
            if (_transformedUsername == null) {
                throw new UnableToAcquireConnectionException("Parameter username in method connect can't be null because is not @Optional");
            }
            String _transformedPassword = (String)this.evaluateAndTransform(this.muleContext, event, this.getClass().getDeclaredField("password").getGenericType(), null, this.getPassword());
            String _transformedDatabase = (String)this.evaluateAndTransform(this.muleContext, event, this.getClass().getDeclaredField("database").getGenericType(), null, this.getDatabase());
            if (_transformedDatabase == null) {
                throw new UnableToAcquireConnectionException("Parameter database in method connect can't be null because is not @Optional");
            }
            return new MongoCloudConnectorConnectionKey(_transformedUsername, _transformedPassword, _transformedDatabase);
        }
        return this.getDefaultConnectionKey();
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public String getModuleVersion() {
        return MODULE_VERSION;
    }

    public String getDevkitVersion() {
        return DEVKIT_VERSION;
    }

    public String getDevkitBuild() {
        return DEVKIT_BUILD;
    }

    public String getMinMuleVersion() {
        return MIN_MULE_VERSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResult test() {
        DefaultTestResult result;
        MongoCloudConnectorConnectionIdentifierAdapter connection = null;
        MongoCloudConnectorConnectionKey key = this.getDefaultConnectionKey();
        try {
            connection = this.acquireConnection(key);
            result = new DefaultTestResult(Result.Status.SUCCESS);
        }
        catch (Exception e) {
            try {
                this.destroyConnection(key, connection);
            }
            catch (Exception ie) {
                // empty catch block
            }
            result = (DefaultTestResult)this.buildFailureTestResult(e);
        }
        finally {
            if (connection != null) {
                try {
                    this.releaseConnection(key, connection);
                }
                catch (Exception ie) {}
            }
        }
        return result;
    }

    public DefaultResult buildFailureTestResult(Exception exception) {
        ConnectionExceptionCode code;
        DefaultTestResult result = exception instanceof ConnectionException ? ((code = ((ConnectionException)exception).getCode()) == ConnectionExceptionCode.UNKNOWN_HOST ? new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.UNKNOWN_HOST, (Throwable)exception) : (code == ConnectionExceptionCode.CANNOT_REACH ? new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.RESOURCE_UNAVAILABLE, (Throwable)exception) : (code == ConnectionExceptionCode.INCORRECT_CREDENTIALS ? new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.INVALID_CREDENTIALS, (Throwable)exception) : (code == ConnectionExceptionCode.CREDENTIALS_EXPIRED ? new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.INVALID_CREDENTIALS, (Throwable)exception) : (code == ConnectionExceptionCode.UNKNOWN ? new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.UNSPECIFIED, (Throwable)exception) : new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.UNSPECIFIED, (Throwable)exception)))))) : new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.UNSPECIFIED, (Throwable)exception);
        return result;
    }
}

