/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.mongo.api;

import com.mongodb.DBObject;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoCollection
extends AbstractCollection<DBObject> {
    private static final Logger logger = LoggerFactory.getLogger(MongoCollection.class);
    private Iterable<? extends DBObject> o;

    public MongoCollection(Iterable<? extends DBObject> o) {
        this.o = o;
    }

    @Override
    public Iterator<DBObject> iterator() {
        return this.o.iterator();
    }

    @Override
    public Object[] toArray() {
        this.warnEagerMessage("toArray");
        LinkedList<DBObject> l = new LinkedList<DBObject>();
        for (DBObject o : this) {
            l.add(o);
        }
        return l.toArray();
    }

    @Override
    public int size() {
        this.warnEagerMessage("size");
        int i = 0;
        Iterator<? extends DBObject> it = this.o.iterator();
        while (it.hasNext()) {
            it.next();
            ++i;
        }
        return i;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
    }

    private void warnEagerMessage(String message) {
        if (logger.isWarnEnabled()) {
            logger.warn("Method {} needs to consume all the element. It is inefficient and thus should be used with care", (Object)message);
        }
    }
}

