/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.mongo.api;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MapReduceCommand;
import com.mongodb.MongoException;
import com.mongodb.WriteResult;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSInputFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.Validate;
import org.bson.types.ObjectId;
import org.mule.module.mongo.api.FieldsSet;
import org.mule.module.mongo.api.IndexOrder;
import org.mule.module.mongo.api.MongoClient;
import org.mule.module.mongo.api.MongoCollection;
import org.mule.module.mongo.api.WriteConcern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoClientImpl
implements MongoClient {
    private static final Logger logger = LoggerFactory.getLogger(MongoClientImpl.class);
    private final DB db;

    public MongoClientImpl(DB db) {
        Validate.notNull((Object)db);
        this.db = db;
    }

    @Override
    public void close() throws IOException {
        try {
            this.db.cleanCursors(true);
        }
        catch (Exception e) {
            logger.warn("Failed to properly clean cursors of db: " + this.db, (Throwable)e);
        }
        try {
            this.db.requestDone();
        }
        catch (Exception e) {
            logger.warn("Failed to properly set request done for db: " + this.db, (Throwable)e);
        }
    }

    @Override
    public long countObjects(@NotNull String collection, DBObject query) {
        Validate.notNull((Object)collection);
        if (query == null) {
            return this.db.getCollection(collection).count();
        }
        return this.db.getCollection(collection).count(query);
    }

    @Override
    public void createCollection(@NotNull String collection, boolean capped, Integer maxObjects, Integer size) {
        Validate.notNull((Object)collection);
        BasicDBObject options = new BasicDBObject("capped", (Object)capped);
        if (maxObjects != null) {
            options.put("maxObject", (Object)maxObjects);
        }
        if (size != null) {
            options.put("size", (Object)size);
        }
        this.db.createCollection(collection, (DBObject)options);
    }

    @Override
    public DBCollection getCollection(@NotNull String collection) {
        Validate.notNull((Object)collection);
        return this.db.getCollection(collection);
    }

    @Override
    public WriteResult addUser(String username, String password) {
        Validate.notNull((Object)username);
        Validate.notNull((Object)password);
        WriteResult writeResult = this.db.addUser(username, password.toCharArray());
        if (!writeResult.getLastError().ok()) {
            throw new MongoException(writeResult.getLastError().getErrorMessage());
        }
        return writeResult;
    }

    @Override
    public void dropDatabase() {
        this.db.dropDatabase();
    }

    @Override
    public void dropCollection(@NotNull String collection) {
        Validate.notNull((Object)collection);
        this.db.getCollection(collection).drop();
    }

    @Override
    public boolean existsCollection(@NotNull String collection) {
        Validate.notNull((Object)collection);
        return this.db.collectionExists(collection);
    }

    @Override
    public Iterable<DBObject> findObjects(@NotNull String collection, DBObject query, List<String> fields, Integer numToSkip, Integer limit, DBObject sortBy) {
        Validate.notNull((Object)collection);
        DBCursor dbCursor = this.db.getCollection(collection).find(query, FieldsSet.from(fields));
        if (numToSkip != null) {
            dbCursor = dbCursor.skip(numToSkip.intValue());
        }
        if (limit != null) {
            dbCursor = dbCursor.limit(limit.intValue());
        }
        if (sortBy != null) {
            dbCursor.sort(sortBy);
        }
        return this.bug5588Workaround((Iterable<? extends DBObject>)dbCursor);
    }

    @Override
    public DBObject findOneObject(@NotNull String collection, DBObject query, List<String> fields, boolean failOnNotFound) {
        Validate.notNull((Object)collection);
        DBObject element = this.db.getCollection(collection).findOne(query, FieldsSet.from(fields));
        if (element == null && failOnNotFound) {
            throw new MongoException("No object found for query " + query);
        }
        return element;
    }

    @Override
    public String insertObject(@NotNull String collection, @NotNull DBObject object, @NotNull WriteConcern writeConcern) {
        Validate.notNull((Object)collection);
        Validate.notNull((Object)object);
        Validate.notNull((Object)((Object)writeConcern));
        this.db.getCollection(collection).insert(object, writeConcern.toMongoWriteConcern(this.db));
        ObjectId id = (ObjectId)object.get("_id");
        if (id == null) {
            return null;
        }
        return id.toStringMongod();
    }

    @Override
    public Collection<String> listCollections() {
        return this.db.getCollectionNames();
    }

    @Override
    public Iterable<DBObject> mapReduceObjects(@NotNull String collection, @NotNull String mapFunction, @NotNull String reduceFunction, String outputCollection) {
        Validate.notNull((Object)collection);
        Validate.notEmpty((String)mapFunction);
        Validate.notEmpty((String)reduceFunction);
        return this.bug5588Workaround(this.db.getCollection(collection).mapReduce(mapFunction, reduceFunction, outputCollection, this.outputTypeFor(outputCollection), null).results());
    }

    private MapReduceCommand.OutputType outputTypeFor(String outputCollection) {
        return outputCollection != null ? MapReduceCommand.OutputType.REPLACE : MapReduceCommand.OutputType.INLINE;
    }

    @Override
    public void removeObjects(@NotNull String collection, DBObject query, @NotNull WriteConcern writeConcern) {
        Validate.notNull((Object)collection);
        Validate.notNull((Object)((Object)writeConcern));
        this.db.getCollection(collection).remove((DBObject)(query != null ? query : new BasicDBObject()), writeConcern.toMongoWriteConcern(this.db));
    }

    @Override
    public void saveObject(@NotNull String collection, @NotNull DBObject object, @NotNull WriteConcern writeConcern) {
        Validate.notNull((Object)collection);
        Validate.notNull((Object)object);
        Validate.notNull((Object)((Object)writeConcern));
        this.db.getCollection(collection).save(object, writeConcern.toMongoWriteConcern(this.db));
    }

    @Override
    public void updateObjects(@NotNull String collection, DBObject query, DBObject object, boolean upsert, boolean multi, WriteConcern writeConcern) {
        Validate.notNull((Object)collection);
        Validate.notNull((Object)((Object)writeConcern));
        this.db.getCollection(collection).update(query, object, upsert, multi, writeConcern.toMongoWriteConcern(this.db));
    }

    @Override
    public void createIndex(String collection, String field, IndexOrder order) {
        this.db.getCollection(collection).createIndex((DBObject)new BasicDBObject(field, (Object)order.getValue()));
    }

    @Override
    public void dropIndex(String collection, String name) {
        this.db.getCollection(collection).dropIndex(name);
    }

    @Override
    public Collection<DBObject> listIndices(String collection) {
        return this.db.getCollection(collection).getIndexInfo();
    }

    @Override
    public DBObject createFile(InputStream content, String filename, String contentType, DBObject metadata) {
        Validate.notNull((Object)filename);
        Validate.notNull((Object)content);
        GridFSInputFile file = this.getGridFs().createFile(content);
        file.setFilename(filename);
        file.setContentType(contentType);
        if (metadata != null) {
            file.setMetaData(metadata);
        }
        file.save();
        return file;
    }

    @Override
    public Iterable<DBObject> findFiles(DBObject query) {
        return this.bug5588Workaround(this.getGridFs().find(query));
    }

    @Override
    public DBObject findOneFile(DBObject query) {
        Validate.notNull((Object)query);
        GridFSDBFile file = this.getGridFs().findOne(query);
        if (file == null) {
            throw new MongoException("No file found for query " + query);
        }
        return file;
    }

    @Override
    public InputStream getFileContent(DBObject query) {
        Validate.notNull((Object)query);
        return ((GridFSDBFile)this.findOneFile(query)).getInputStream();
    }

    @Override
    public Iterable<DBObject> listFiles(DBObject query) {
        return this.bug5588Workaround((Iterable<? extends DBObject>)this.getGridFs().getFileList(query));
    }

    @Override
    public void removeFiles(DBObject query) {
        this.getGridFs().remove(query);
    }

    @Override
    public DBObject executeComamnd(DBObject command) {
        return this.db.command(command);
    }

    @Override
    public void requestStart() {
        this.db.requestStart();
    }

    @Override
    public void requestDone() {
        this.db.requestDone();
    }

    protected GridFS getGridFs() {
        return new GridFS(this.db);
    }

    private Iterable<DBObject> bug5588Workaround(Iterable<? extends DBObject> o) {
        if (o instanceof Collection) {
            return o;
        }
        return new MongoCollection(o);
    }

    public DB getDb() {
        return this.db;
    }
}

