/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.mongo.api;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.mule.module.mongo.MongoCloudConnector;
import org.mule.module.mongo.api.MongoClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MongoClientAdaptor {
    private static final Logger logger = LoggerFactory.getLogger(MongoCloudConnector.class);

    private MongoClientAdaptor() {
    }

    public static MongoClient adapt(final MongoClient receptor) {
        return (MongoClient)Proxy.newProxyInstance(MongoClient.class.getClassLoader(), new Class[]{MongoClient.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Entering {} with args {}", (Object)method.getName(), (Object)args);
                    }
                    Object ret = method.invoke((Object)receptor, args);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Returning from {} with value {}", (Object)method.getName(), ret);
                    }
                    return ret;
                }
                catch (InvocationTargetException e) {
                    if (logger.isWarnEnabled()) {
                        logger.warn("An exception was thrown while invoking {}: {}", (Object)method.getName(), (Object)e);
                    }
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
        });
    }
}

