/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.mongo.api;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bson.types.ObjectId;

public final class DBObjects {
    private static final Pattern OBJECT_ID_PATTERN = Pattern.compile("ObjectId\\((.+)\\)");

    private DBObjects() {
    }

    public static DBObject fromMap(Map<String, Object> map) {
        return new BasicDBObject(map);
    }

    public static DBObject from(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof DBObject) {
            return (DBObject)o;
        }
        if (o instanceof Map) {
            return DBObjects.fromMap((Map)o);
        }
        throw new IllegalArgumentException("Unsupported object type " + o);
    }

    public static DBObject fromFunction(String function, DBObject dbObject) {
        return new BasicDBObject(function, (Object)dbObject);
    }

    public static DBObject fromCommand(String commandName, String commandValue) {
        BasicDBObject dbObject = commandValue == null ? new BasicDBObject(commandName, (Object)1) : new BasicDBObject(commandName, (Object)commandValue);
        return dbObject;
    }

    public static Object adapt(Object o) {
        Object obj = o;
        if (obj instanceof DBObject) {
            DBObjects.adaptObjectId((DBObject)obj);
            DBObjects.adaptAttributes((DBObject)obj);
        } else if (obj instanceof Map) {
            obj = DBObjects.adapt(DBObjects.fromMap((Map)o));
        } else if (obj instanceof List) {
            DBObjects.adaptElements(obj);
        }
        return obj;
    }

    private static void adaptElements(Object o) {
        ListIterator<Object> iter = ((List)o).listIterator();
        while (iter.hasNext()) {
            iter.set(DBObjects.adapt(iter.next()));
        }
    }

    private static void adaptAttributes(DBObject o) {
        for (String key : o.keySet()) {
            o.put(key, DBObjects.adapt(o.get(key)));
        }
    }

    private static void adaptObjectId(DBObject o) {
        Matcher m;
        Object id = o.get("_id");
        if (id != null && id instanceof String && (m = DBObjects.objectIdMatcher(id)).matches()) {
            o.put("_id", (Object)new ObjectId(m.group(1)));
        }
    }

    private static Matcher objectIdMatcher(Object id) {
        return OBJECT_ID_PATTERN.matcher((String)id);
    }
}

