/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.bson.types.ObjectId;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.store.ObjectDoesNotExistException;
import org.mule.api.store.ObjectStoreException;
import org.mule.api.store.PartitionableExpirableObjectStore;
import org.mule.module.mongo.api.IndexOrder;
import org.mule.module.mongo.api.MongoClient;
import org.mule.module.mongo.api.MongoClientImpl;
import org.mule.module.mongo.api.WriteConcern;
import org.mule.util.SerializationUtils;
import org.springframework.util.DigestUtils;

public class MongoObjectStore
implements PartitionableExpirableObjectStore<Serializable>,
MuleContextAware {
    private static final String OBJECTSTORE_COLLECTION_PREFIX = "mule.objectstore.";
    private static final String OBJECTSTORE_DEFAULT_PARTITION_NAME = "_default";
    private static final String ID_FIELD = "_id";
    private static final String KEY_FIELD = "key";
    private static final String TIMESTAMP_FIELD = "timestamp";
    private static final String VALUE_FIELD = "value";
    private static final List<String> NO_FIELD_LIST = Collections.emptyList();
    private String host;
    private int port;
    private String database;
    private String username;
    private String password;
    private WriteConcern writeConcern;
    private MongoClient mongoClient;
    private MuleContext context;

    @PostConstruct
    public void initialize() throws UnknownHostException {
        DB db = new com.mongodb.MongoClient(this.host, this.port).getDB(this.database);
        if (StringUtils.isNotEmpty((String)this.password)) {
            Validate.notEmpty((String)this.username, (String)"Username must not be empty if password is set");
            db.authenticate(this.username, this.password.toCharArray());
        }
        this.mongoClient = new MongoClientImpl(db);
    }

    public boolean isPersistent() {
        return true;
    }

    public void open() throws ObjectStoreException {
        this.open(OBJECTSTORE_DEFAULT_PARTITION_NAME);
    }

    public void close() throws ObjectStoreException {
        this.close(OBJECTSTORE_DEFAULT_PARTITION_NAME);
    }

    public List<Serializable> allKeys() throws ObjectStoreException {
        return this.allKeys(OBJECTSTORE_DEFAULT_PARTITION_NAME);
    }

    public void expire(int entryTtl, int maxEntries) throws ObjectStoreException {
        this.expire(entryTtl, maxEntries, OBJECTSTORE_DEFAULT_PARTITION_NAME);
    }

    public boolean contains(Serializable key) throws ObjectStoreException {
        return this.contains(key, OBJECTSTORE_DEFAULT_PARTITION_NAME);
    }

    public void store(Serializable key, Serializable value) throws ObjectStoreException {
        this.store(key, value, OBJECTSTORE_DEFAULT_PARTITION_NAME);
    }

    public Serializable retrieve(Serializable key) throws ObjectStoreException {
        return this.retrieve(key, OBJECTSTORE_DEFAULT_PARTITION_NAME);
    }

    public Serializable remove(Serializable key) throws ObjectStoreException {
        return this.remove(key, OBJECTSTORE_DEFAULT_PARTITION_NAME);
    }

    public void open(String partitionName) throws ObjectStoreException {
    }

    public void close(String partitionName) throws ObjectStoreException {
    }

    public boolean contains(Serializable key, String partitionName) throws ObjectStoreException {
        ObjectId objectId = this.getObjectIdFromKey(key);
        DBObject query = this.getQueryForObjectId(objectId);
        String collection = this.getCollectionName(partitionName);
        return this.mongoClient.findObjects(collection, query, NO_FIELD_LIST, null, null, null).iterator().hasNext();
    }

    public List<Serializable> allKeys(String partitionName) throws ObjectStoreException {
        String collection = this.getCollectionName(partitionName);
        Iterable<DBObject> keyObjects = this.mongoClient.findObjects(collection, (DBObject)new BasicDBObject(), Arrays.asList(KEY_FIELD), null, null, null);
        ArrayList<Serializable> results = new ArrayList<Serializable>();
        for (DBObject keyObject : keyObjects) {
            results.add((Serializable)SerializationUtils.deserialize((byte[])((byte[])keyObject.get(KEY_FIELD))));
        }
        return results;
    }

    public List<String> allPartitions() throws ObjectStoreException {
        ArrayList<String> results = new ArrayList<String>();
        for (String collection : this.mongoClient.listCollections()) {
            if (!this.isPartition(collection)) continue;
            results.add(this.getPartitionName(collection));
        }
        return results;
    }

    public void store(Serializable key, Serializable value, String partitionName) throws ObjectStoreException {
        String collection = this.getCollectionName(partitionName);
        if (!this.mongoClient.existsCollection(collection)) {
            this.mongoClient.createCollection(collection, false, null, null);
            this.mongoClient.createIndex(collection, TIMESTAMP_FIELD, IndexOrder.ASC);
        }
        byte[] keyAsBytes = SerializationUtils.serialize((Serializable)key);
        ObjectId objectId = this.getObjectIdFromKey(keyAsBytes);
        DBObject query = this.getQueryForObjectId(objectId);
        BasicDBObject dbObject = new BasicDBObject();
        dbObject.put(ID_FIELD, (Object)objectId);
        dbObject.put(TIMESTAMP_FIELD, (Object)System.currentTimeMillis());
        dbObject.put(KEY_FIELD, (Object)keyAsBytes);
        dbObject.put(VALUE_FIELD, (Object)SerializationUtils.serialize((Serializable)value));
        this.mongoClient.updateObjects(collection, query, (DBObject)dbObject, true, false, this.getWriteConcern());
    }

    public Serializable retrieve(Serializable key, String partitionName) throws ObjectStoreException {
        String collection = this.getCollectionName(partitionName);
        ObjectId objectId = this.getObjectIdFromKey(key);
        DBObject query = this.getQueryForObjectId(objectId);
        return this.retrieveSerializedObject(collection, query);
    }

    public Serializable remove(Serializable key, String partitionName) throws ObjectStoreException {
        String collection = this.getCollectionName(partitionName);
        ObjectId objectId = this.getObjectIdFromKey(key);
        DBObject query = this.getQueryForObjectId(objectId);
        Serializable result = this.retrieveSerializedObject(collection, query);
        this.mongoClient.removeObjects(collection, query, this.getWriteConcern());
        return result;
    }

    public void disposePartition(String partitionName) throws ObjectStoreException {
        String collection = this.getCollectionName(partitionName);
        this.mongoClient.dropCollection(collection);
    }

    public void clear(String s) throws ObjectStoreException {
    }

    public void clear() throws ObjectStoreException {
    }

    public void expire(int entryTtl, int ignoredMaxEntries, String partitionName) throws ObjectStoreException {
        String collection = this.getCollectionName(partitionName);
        long expireAt = System.currentTimeMillis() - (long)entryTtl;
        DBObject query = QueryBuilder.start((String)TIMESTAMP_FIELD).lessThan((Object)expireAt).get();
        this.mongoClient.removeObjects(collection, query, this.getWriteConcern());
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public void setWriteConcern(WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
    }

    private String getCollectionName(String partitionName) {
        return OBJECTSTORE_COLLECTION_PREFIX + partitionName;
    }

    private String getPartitionName(String collectionName) {
        return StringUtils.substringAfter((String)collectionName, (String)OBJECTSTORE_COLLECTION_PREFIX);
    }

    private boolean isPartition(String collectionName) {
        return StringUtils.startsWith((String)collectionName, (String)OBJECTSTORE_COLLECTION_PREFIX);
    }

    private ObjectId getObjectIdFromKey(Serializable key) {
        byte[] keyAsBytes = SerializationUtils.serialize((Serializable)key);
        return this.getObjectIdFromKey(keyAsBytes);
    }

    private ObjectId getObjectIdFromKey(byte[] keyAsBytes) {
        byte[] md5Digest = DigestUtils.md5Digest((byte[])keyAsBytes);
        byte[] id = ArrayUtils.subarray((byte[])md5Digest, (int)0, (int)12);
        for (int i = 0; i < 4; ++i) {
            id[i * 3] = (byte)(id[i * 3] ^ md5Digest[12 + i]);
        }
        ObjectId objectId = new ObjectId(id);
        return objectId;
    }

    private DBObject getQueryForObjectId(ObjectId objectId) {
        return new BasicDBObject(ID_FIELD, (Object)objectId);
    }

    private Serializable retrieveSerializedObject(String collection, DBObject query) throws ObjectDoesNotExistException {
        Iterator<DBObject> iterator = this.mongoClient.findObjects(collection, query, Arrays.asList(VALUE_FIELD), null, null, null).iterator();
        if (!iterator.hasNext()) {
            throw new ObjectDoesNotExistException();
        }
        DBObject dbObject = iterator.next();
        return (Serializable)SerializationUtils.deserialize((byte[])((byte[])dbObject.get(VALUE_FIELD)), (MuleContext)this.context);
    }

    public void setMuleContext(MuleContext context) {
        this.context = context;
    }
}

