/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.management.agent;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.agent.AbstractAgent;
import org.mule.runtime.core.api.agent.Agent;
import org.mule.runtime.core.api.registry.MuleRegistry;
import org.mule.runtime.core.api.registry.RegistrationException;
import org.mule.runtime.core.config.bootstrap.ArtifactType;
import org.mule.runtime.core.util.StringUtils;
import org.mule.runtime.module.management.agent.AbstractJmxAgent;
import org.mule.runtime.module.management.agent.AbstractJmxAgentExtension;
import org.mule.runtime.module.management.agent.ConfigurableJMXAuthenticator;
import org.mule.runtime.module.management.agent.FixedHostRmiClientSocketFactory;
import org.mule.runtime.module.management.agent.JdmkAgent;
import org.mule.runtime.module.management.agent.JmxApplicationAgent;
import org.mule.runtime.module.management.agent.JmxDomainAgent;
import org.mule.runtime.module.management.agent.JmxServerNotificationAgent;
import org.mule.runtime.module.management.agent.Log4jAgent;
import org.mule.runtime.module.management.agent.Mx4jAgent;
import org.mule.runtime.module.management.agent.RmiRegistryAgent;
import org.mule.runtime.module.management.agent.YourKitProfilerAgent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJmxSupportAgent
extends AbstractAgent {
    private static final Logger logger = LoggerFactory.getLogger(DefaultJmxSupportAgent.class);
    public static final String DEFAULT_HOST = "localhost";
    public static final String DEFAULT_PORT = "1099";
    private final boolean loadLog4jAgent = false;
    private boolean loadJdmkAgent = false;
    private boolean loadMx4jAgent = false;
    private boolean loadProfilerAgent = false;
    private String port;
    private String host;
    private ConfigurableJMXAuthenticator jmxAuthenticator;
    private Map<String, String> credentials = new HashMap<String, String>();

    public DefaultJmxSupportAgent() {
        super("jmx-default-config");
    }

    public String getDescription() {
        return "Default Jmx Support Agent";
    }

    public void start() throws MuleException {
    }

    public void stop() throws MuleException {
    }

    public void dispose() {
    }

    public void initialise() throws InitialisationException {
        try {
            Object agent = this.createRmiAgent();
            MuleRegistry registry = this.muleContext.getRegistry();
            if (!this.isAgentRegistered((Agent)agent)) {
                agent.initialise();
                this.registerAgent((Agent)agent, registry);
            }
            agent = this.createJmxAgent();
            if (this.lookupJmxAgent(registry) == null) {
                this.registerAgent((Agent)agent, registry);
            }
            if (!this.isAgentRegistered((Agent)(agent = this.createJmxNotificationAgent()))) {
                this.registerAgent((Agent)agent, registry);
            }
            if (this.loadJdmkAgent && !this.isAgentRegistered((Agent)(agent = this.createJdmkAgent()))) {
                this.registerAgent((Agent)agent, registry);
            }
            if (this.loadMx4jAgent && !this.isAgentRegistered((Agent)(agent = this.createMx4jAgent()))) {
                this.registerAgent((Agent)agent, registry);
            }
            if (this.loadProfilerAgent && !this.isAgentRegistered((Agent)(agent = this.createProfilerAgent()))) {
                this.registerAgent((Agent)agent, registry);
            }
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    protected AbstractJmxAgent lookupJmxAgent(MuleRegistry registry) throws RegistrationException {
        ArtifactType artifactType = this.muleContext.getArtifactType();
        if (ArtifactType.APP.equals((Object)artifactType)) {
            return (AbstractJmxAgent)((Object)registry.lookupObject(JmxApplicationAgent.class));
        }
        if (ArtifactType.DOMAIN.equals((Object)artifactType)) {
            return (AbstractJmxAgent)((Object)registry.lookupObject(JmxDomainAgent.class));
        }
        AbstractJmxAgent lookupObject = (AbstractJmxAgent)((Object)registry.lookupObject(AbstractJmxAgentExtension.class));
        if (lookupObject == null) {
            lookupObject = (AbstractJmxAgent)((Object)registry.lookupObject(AbstractJmxAgent.class));
        }
        return lookupObject;
    }

    protected void registerAgent(Agent agent, MuleRegistry registry) throws MuleException {
        registry.registerAgent(agent);
    }

    public AbstractJmxAgent createJmxAgent() {
        AbstractJmxAgent agent;
        try {
            agent = this.lookupJmxAgent(this.muleContext.getRegistry());
        }
        catch (RegistrationException e) {
            throw new RuntimeException(e);
        }
        String remotingUri = null;
        if (StringUtils.isBlank((String)this.host) && StringUtils.isBlank((String)this.port)) {
            remotingUri = "service:jmx:rmi:///jndi/rmi://localhost:1099/server";
        } else if (StringUtils.isNotBlank((String)this.host)) {
            Map<String, Object> props = agent.getConnectorServerProperties();
            HashMap<String, Object> mergedProps = new HashMap<String, Object>(props.size() + 1);
            mergedProps.putAll(props);
            FixedHostRmiClientSocketFactory factory = new FixedHostRmiClientSocketFactory(this.host);
            mergedProps.put("jmx.remote.rmi.client.socket.factory", factory);
            agent.setConnectorServerProperties(mergedProps);
        }
        if (StringUtils.isBlank((String)remotingUri)) {
            remotingUri = MessageFormat.format("service:jmx:rmi:///jndi/rmi://{0}:{1}/server", StringUtils.defaultString((String)this.host, (String)DEFAULT_HOST), StringUtils.defaultString((String)this.port, (String)DEFAULT_PORT));
        }
        if (this.credentials != null && !this.credentials.isEmpty()) {
            agent.setCredentials(this.credentials);
        }
        agent.setConnectorServerUrl(remotingUri);
        agent.setJmxAuthenticator(this.jmxAuthenticator);
        return agent;
    }

    protected Log4jAgent createLog4jAgent() {
        return new Log4jAgent();
    }

    protected RmiRegistryAgent createRmiAgent() {
        RmiRegistryAgent agent = new RmiRegistryAgent();
        agent.setHost(StringUtils.defaultString((String)this.host, (String)DEFAULT_HOST));
        agent.setPort(StringUtils.defaultString((String)this.port, (String)DEFAULT_PORT));
        return agent;
    }

    protected JmxServerNotificationAgent createJmxNotificationAgent() {
        return new JmxServerNotificationAgent();
    }

    protected Mx4jAgent createMx4jAgent() {
        return new Mx4jAgent();
    }

    protected JdmkAgent createJdmkAgent() {
        return new JdmkAgent();
    }

    protected YourKitProfilerAgent createProfilerAgent() {
        return new YourKitProfilerAgent();
    }

    protected boolean isAgentRegistered(Agent agent) {
        return this.muleContext.getRegistry().lookupAgent(agent.getName()) != null;
    }

    public boolean isLoadLog4jAgent() {
        return false;
    }

    public void setLoadLog4jAgent(boolean loadLog4jAgent) {
        if (loadLog4jAgent) {
            logger.warn("Log4jAgent is deprecated since Mule 3.6.0 because log4j2 already supports JMX OOTB. Thus, enabling it here will have no effect. Check migration guide for more information");
        }
    }

    public boolean isLoadJdmkAgent() {
        return this.loadJdmkAgent;
    }

    public void setLoadJdmkAgent(boolean loadJdmkAgent) {
        this.loadJdmkAgent = loadJdmkAgent;
    }

    public boolean isLoadMx4jAgent() {
        return this.loadMx4jAgent;
    }

    public void setLoadMx4jAgent(boolean loadMx4jAgent) {
        this.loadMx4jAgent = loadMx4jAgent;
    }

    public boolean isLoadProfilerAgent() {
        return this.loadProfilerAgent;
    }

    public void setLoadProfilerAgent(boolean loadProfilerAgent) {
        this.loadProfilerAgent = loadProfilerAgent;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    @Deprecated
    public String getHost() {
        return this.host;
    }

    @Deprecated
    public void setHost(String host) {
        logger.warn("The host attribute for jmx-default-config is deprecated, for multi-homed hosts consider using instead the Java system property java.rmi.server.hostname");
        this.host = host;
    }

    public void setCredentials(Map<String, String> credentials) {
        this.credentials = credentials;
    }

    public ConfigurableJMXAuthenticator getJmxAuthenticator() {
        return this.jmxAuthenticator;
    }

    public void setJmxAuthenticator(ConfigurableJMXAuthenticator jmxAuthenticator) {
        this.jmxAuthenticator = jmxAuthenticator;
    }
}

