/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.management.mbean;

import com.yourkit.api.Controller;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.runtime.module.management.i18n.ManagementMessages;
import org.mule.runtime.module.management.mbean.YourKitProfilerServiceMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YourKitProfilerService
implements YourKitProfilerServiceMBean {
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Controller controller;
    private final AtomicBoolean capturing = new AtomicBoolean(false);

    public YourKitProfilerService() throws Exception {
        this.controller = new Controller();
    }

    @Override
    public String getHost() {
        return this.controller.getHost();
    }

    @Override
    public int getPort() {
        return this.controller.getPort();
    }

    @Override
    public String captureMemorySnapshot() throws Exception {
        return this.controller.captureMemorySnapshot();
    }

    @Override
    public String captureSnapshot(long snapshotFlags) throws Exception {
        return this.controller.captureSnapshot(snapshotFlags);
    }

    @Override
    public void startAllocationRecording(long mode) throws Exception {
        if (66L != mode && 2L != mode) {
            throw new IllegalArgumentException("Invalid allocation recording mode requested: " + mode);
        }
        if (mode == 2L) {
            this.controller.startAllocationRecording(true, 1, false, 0);
        } else {
            this.controller.startAllocationRecording(true, 10, true, 0x100000);
        }
    }

    @Override
    public void stopAllocationRecording() throws Exception {
        this.controller.stopAllocationRecording();
    }

    @Override
    public void startCPUProfiling(long mode, String filters) throws Exception {
        this.controller.startCPUProfiling(mode, filters);
    }

    @Override
    public void stopCPUProfiling() throws Exception {
        this.controller.stopCPUProfiling();
    }

    @Override
    public void startMonitorProfiling() throws Exception {
        this.controller.startMonitorProfiling();
    }

    @Override
    public void stopMonitorProfiling() throws Exception {
        this.controller.stopMonitorProfiling();
    }

    @Override
    public void advanceGeneration(String description) throws Exception {
        this.controller.advanceGeneration(description);
    }

    @Override
    public String forceGC() throws Exception {
        long[] heapSizes = this.controller.forceGC();
        return ManagementMessages.forceGC(heapSizes).getMessage();
    }

    @Override
    public void startCapturingMemSnapshot(final int seconds) {
        if (!this.capturing.compareAndSet(false, true)) {
            return;
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (YourKitProfilerService.this.capturing.get()) {
                        YourKitProfilerService.this.controller.captureMemorySnapshot();
                        Thread.sleep(seconds * 1000);
                    }
                }
                catch (Exception e) {
                    YourKitProfilerService.this.logger.error("Failed to capture memory snapshot", (Throwable)e);
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void stopCapturingMemSnapshot() {
        this.capturing.set(false);
    }

    @Override
    public long getStatus() throws Exception {
        return this.capturing.get() ? this.controller.getStatus() | 0x100L : this.controller.getStatus();
    }
}

