/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.management.mbean;

import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.construct.AbstractFlowConstruct;
import org.mule.runtime.core.management.stats.FlowConstructStatistics;
import org.mule.runtime.module.management.mbean.FlowConstructServiceMBean;
import org.mule.runtime.module.management.mbean.FlowConstructStats;
import org.mule.runtime.module.management.mbean.FlowConstructStatsMBean;
import org.mule.runtime.module.management.support.AutoDiscoveryJmxSupportFactory;
import org.mule.runtime.module.management.support.JmxSupport;
import org.mule.runtime.module.management.support.JmxSupportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowConstructService
implements FlowConstructServiceMBean,
MBeanRegistration,
FlowConstructStatsMBean {
    private static Logger LOGGER = LoggerFactory.getLogger(FlowConstructService.class);
    protected FlowConstructStatistics statistics;
    protected MBeanServer server;
    protected String name;
    protected String type;
    protected ObjectName statsName;
    protected ObjectName objectName;
    protected MuleContext muleContext;
    protected JmxSupportFactory jmxSupportFactory = AutoDiscoveryJmxSupportFactory.getInstance();
    protected JmxSupport jmxSupport = this.jmxSupportFactory.getJmxSupport();

    public FlowConstructService(String type, String name, MuleContext muleContext, FlowConstructStatistics statistics) {
        this.muleContext = muleContext;
        this.type = type;
        this.name = name;
        this.statistics = statistics;
    }

    protected FlowConstructService(String type, String name, MuleContext muleContext) {
        this.muleContext = muleContext;
        this.type = type;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public ObjectName getStatistics() {
        return this.statsName;
    }

    @Override
    public void clearStatistics() {
        this.statistics.clear();
    }

    @Override
    public long getAsyncEventsReceived() {
        return this.statistics.getAsyncEventsReceived();
    }

    @Override
    public long getSyncEventsReceived() {
        return this.statistics.getSyncEventsReceived();
    }

    @Override
    public long getTotalEventsReceived() {
        return this.statistics.getTotalEventsReceived();
    }

    @Override
    public long getAverageProcessingTime() {
        return this.statistics.getAverageProcessingTime();
    }

    @Override
    public long getProcessedEvents() {
        return this.statistics.getProcessedEvents();
    }

    @Override
    public long getMaxProcessingTime() {
        return this.statistics.getMaxProcessingTime();
    }

    @Override
    public long getMinProcessingTime() {
        return this.statistics.getMinProcessingTime();
    }

    @Override
    public long getTotalProcessingTime() {
        return this.statistics.getTotalProcessingTime();
    }

    @Override
    public long getExecutionErrors() {
        return this.statistics.getExecutionErrors();
    }

    @Override
    public long getFatalErrors() {
        return this.statistics.getFatalErrors();
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        this.objectName = name;
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        AbstractFlowConstruct flow = (AbstractFlowConstruct)this.muleContext.getRegistry().lookupObject(this.getName());
        try {
            if (flow.getStatistics() != null) {
                this.statsName = this.jmxSupport.getObjectName(String.format("%s:type=org.mule.Statistics,%s=%s", this.objectName.getDomain(), flow.getConstructType(), this.jmxSupport.escape(this.getName())));
                if (this.server.isRegistered(this.statsName)) {
                    this.server.unregisterMBean(this.statsName);
                }
                this.server.registerMBean(new FlowConstructStats(flow.getStatistics()), this.statsName);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error post-registering the MBean", (Throwable)e);
        }
    }

    @Override
    public void preDeregister() throws Exception {
        try {
            if (this.server.isRegistered(this.statsName)) {
                this.server.unregisterMBean(this.statsName);
            }
        }
        catch (Exception ex) {
            LOGGER.error("Error unregistering ServiceService child " + this.statsName.getCanonicalName(), (Throwable)ex);
        }
    }

    @Override
    public void postDeregister() {
    }
}

