/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.management.agent;

import java.net.URI;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.AbstractAgent;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.core.util.StringUtils;
import org.mule.runtime.module.management.agent.JmxManagementException;

public class JdmkAgent
extends AbstractAgent {
    public static final String CLASSNAME_ADAPTER = "com.sun.jdmk.comm.HtmlAdaptorServer";
    private static final String PROTOCOL_PREFIX = "http://";
    public static final String DEFAULT_HOSTNAME = "localhost";
    public static final int DEFAULT_PORT = 9092;
    public static final String DEFAULT_JMX_ADAPTOR_URL = "http://localhost:9092";
    private String jmxAdaptorUrl;
    private String host;
    private String port;
    private MBeanServer mBeanServer;
    private ObjectName adaptorName;

    public JdmkAgent() {
        super("jdmk-agent");
    }

    protected Object createAdaptor() throws Exception {
        URI uri = new URI(this.jmxAdaptorUrl);
        int port = uri.getPort();
        return ClassUtils.instanciateClass((String)CLASSNAME_ADAPTER, (Object[])new Object[]{new Integer(port)}, ((Object)((Object)this)).getClass());
    }

    public String getDescription() {
        return "Jdmk Http adaptor: " + this.jmxAdaptorUrl;
    }

    public void start() throws MuleException {
        try {
            this.mBeanServer.invoke(this.adaptorName, "start", null, null);
        }
        catch (InstanceNotFoundException e) {
            throw new JmxManagementException(CoreMessages.failedToStart((String)"Jdmk agent"), this.adaptorName, e);
        }
        catch (MBeanException e) {
            throw new JmxManagementException(CoreMessages.failedToStart((String)"Jdmk agent"), this.adaptorName, e);
        }
        catch (ReflectionException reflectionException) {
            // empty catch block
        }
    }

    public void stop() throws MuleException {
        if (this.mBeanServer == null) {
            return;
        }
        try {
            this.mBeanServer.invoke(this.adaptorName, "stop", null, null);
        }
        catch (InstanceNotFoundException e) {
            throw new JmxManagementException(CoreMessages.failedToStop((String)"Jdmk agent"), this.adaptorName, e);
        }
        catch (MBeanException e) {
            throw new JmxManagementException(CoreMessages.failedToStop((String)"Jdmk agent"), this.adaptorName, e);
        }
        catch (ReflectionException reflectionException) {
            // empty catch block
        }
    }

    public void dispose() {
        try {
            this.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initialise() throws InitialisationException {
        try {
            this.mBeanServer = MBeanServerFactory.findMBeanServer(null).get(0);
            Object adaptor = this.createAdaptor();
            if (StringUtils.isBlank((String)this.jmxAdaptorUrl)) {
                this.jmxAdaptorUrl = StringUtils.isNotBlank((String)this.host) && StringUtils.isNotBlank((String)this.port) ? PROTOCOL_PREFIX + this.host + ":" + this.port : DEFAULT_JMX_ADAPTOR_URL;
            }
            this.adaptorName = new ObjectName("Adaptor:class=" + adaptor.getClass().getName());
            this.mBeanServer.registerMBean(adaptor, this.adaptorName);
        }
        catch (Exception e) {
            throw new InitialisationException(CoreMessages.failedToStart((String)"Jdmk Agent"), (Throwable)e, (Initialisable)this);
        }
    }

    public String getJmxAdaptorUrl() {
        return this.jmxAdaptorUrl;
    }

    public void setJmxAdaptorUrl(String jmxAdaptorUrl) {
        this.jmxAdaptorUrl = jmxAdaptorUrl;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }
}

