/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.management.support;

import java.io.ObjectStreamException;
import java.lang.reflect.Method;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.module.management.support.JmxLegacySupport;
import org.mule.module.management.support.JmxModernSupport;
import org.mule.module.management.support.JmxSupport;
import org.mule.module.management.support.JmxSupportFactory;
import org.mule.util.ClassUtils;

public class AutoDiscoveryJmxSupportFactory
implements JmxSupportFactory {
    private static final JmxSupportFactory instance = new AutoDiscoveryJmxSupportFactory();
    private transient Log logger = LogFactory.getLog(this.getClass());
    private JmxSupport jmxSupport;

    protected AutoDiscoveryJmxSupportFactory() {
        boolean jmxModernAvailable = this.isModernSpecAvailable();
        this.jmxSupport = jmxModernAvailable ? new JmxModernSupport() : new JmxLegacySupport();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("JMX support instance is " + this.jmxSupport));
        }
    }

    public static JmxSupportFactory getInstance() {
        return instance;
    }

    @Override
    public JmxSupport getJmxSupport() {
        return this.jmxSupport;
    }

    protected boolean isModernSpecAvailable() {
        Class<ObjectName> clazz = ObjectName.class;
        Method method = ClassUtils.getMethod(clazz, (String)"quote", (Class[])new Class[]{String.class});
        return method != null;
    }

    private Object readResolve() throws ObjectStreamException {
        return instance;
    }
}

