/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.management.mbean;

import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.construct.AbstractFlowConstruct;
import org.mule.management.stats.FlowConstructStatistics;
import org.mule.module.management.mbean.FlowConstructServiceMBean;
import org.mule.module.management.mbean.FlowConstructStats;
import org.mule.module.management.mbean.FlowConstructStatsMBean;

public class FlowConstructService
implements FlowConstructServiceMBean,
MBeanRegistration,
FlowConstructStatsMBean {
    private static Log LOGGER = LogFactory.getLog(FlowConstructService.class);
    protected FlowConstructStatistics statistics;
    protected MBeanServer server;
    protected String name;
    protected String type;
    protected ObjectName statsName;
    protected ObjectName objectName;
    protected MuleContext muleContext;

    public FlowConstructService(String type, String name, MuleContext muleContext, FlowConstructStatistics statistics) {
        this.muleContext = muleContext;
        this.type = type;
        this.name = name;
        this.statistics = statistics;
    }

    protected FlowConstructService(String type, String name, MuleContext muleContext) {
        this.muleContext = muleContext;
        this.type = type;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public ObjectName getStatistics() {
        return this.statsName;
    }

    @Override
    public void clearStatistics() {
        this.statistics.clear();
    }

    @Override
    public long getAsyncEventsReceived() {
        return this.statistics.getAsyncEventsReceived();
    }

    @Override
    public long getSyncEventsReceived() {
        return this.statistics.getSyncEventsReceived();
    }

    @Override
    public long getTotalEventsReceived() {
        return this.statistics.getTotalEventsReceived();
    }

    @Override
    public long getAverageProcessingTime() {
        return this.statistics.getAverageProcessingTime();
    }

    @Override
    public long getProcessedEvents() {
        return this.statistics.getProcessedEvents();
    }

    @Override
    public long getMaxProcessingTime() {
        return this.statistics.getMaxProcessingTime();
    }

    @Override
    public long getMinProcessingTime() {
        return this.statistics.getMinProcessingTime();
    }

    @Override
    public long getTotalProcessingTime() {
        return this.statistics.getTotalProcessingTime();
    }

    @Override
    public long getExecutionErrors() {
        return this.statistics.getExecutionErrors();
    }

    @Override
    public long getFatalErrors() {
        return this.statistics.getFatalErrors();
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        this.objectName = name;
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        AbstractFlowConstruct flow = (AbstractFlowConstruct)this.muleContext.getRegistry().lookupObject(this.getName());
        try {
            if (flow.getStatistics() != null) {
                this.statsName = new ObjectName(this.objectName.getDomain() + ":type=org.mule.Statistics," + flow.getConstructType() + "=" + this.getName());
                if (this.server.isRegistered(this.statsName)) {
                    this.server.unregisterMBean(this.statsName);
                }
                this.server.registerMBean(new FlowConstructStats(flow.getStatistics()), this.statsName);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error post-registering the MBean", (Throwable)e);
        }
    }

    @Override
    public void preDeregister() throws Exception {
        try {
            if (this.server.isRegistered(this.statsName)) {
                this.server.unregisterMBean(this.statsName);
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Error unregistering ServiceService child " + this.statsName.getCanonicalName()), (Throwable)ex);
        }
    }

    @Override
    public void postDeregister() {
    }
}

