/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.management.agent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.agent.Agent;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.management.i18n.ManagementMessages;
import org.mule.module.management.mbean.YourKitProfilerService;
import org.mule.module.management.support.AutoDiscoveryJmxSupportFactory;
import org.mule.module.management.support.JmxSupport;
import org.mule.module.management.support.JmxSupportFactory;
import org.mule.util.ClassUtils;

public class YourKitProfilerAgent
implements Agent,
MuleContextAware {
    public static final String PROFILER_OBJECT_NAME = "name=Profiler";
    private String name = "yourkit-profiler";
    private MBeanServer mBeanServer;
    private ObjectName profilerName;
    private JmxSupportFactory jmxSupportFactory = AutoDiscoveryJmxSupportFactory.getInstance();
    private JmxSupport jmxSupport = this.jmxSupportFactory.getJmxSupport();
    protected static final Log logger = LogFactory.getLog(YourKitProfilerAgent.class);
    protected MuleContext muleContext;

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return "Profiler JMX Agent";
    }

    public List getDependentAgents() {
        return Collections.EMPTY_LIST;
    }

    public void initialise() throws InitialisationException {
        if (!this.isApiAvailable()) {
            logger.warn((Object)"Cannot find YourKit API. Profiler JMX Agent will be unregistered.");
            this.unregisterMeQuietly();
            return;
        }
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        if (servers.isEmpty()) {
            throw new InitialisationException(ManagementMessages.noMBeanServerAvailable(), (Initialisable)this);
        }
        try {
            this.mBeanServer = (MBeanServer)servers.get(0);
            this.profilerName = this.jmxSupport.getObjectName(this.jmxSupport.getDomainName(this.muleContext) + ":" + PROFILER_OBJECT_NAME);
            this.unregisterMBeansIfNecessary();
            this.mBeanServer.registerMBean(new YourKitProfilerService(), this.profilerName);
        }
        catch (Exception e) {
            throw new InitialisationException(CoreMessages.failedToStart((String)this.getName()), (Throwable)e, (Initialisable)this);
        }
    }

    protected void unregisterMBeansIfNecessary() throws MalformedObjectNameException, InstanceNotFoundException, MBeanRegistrationException {
        if (this.mBeanServer == null || this.profilerName == null) {
            return;
        }
        if (this.mBeanServer.isRegistered(this.profilerName)) {
            this.mBeanServer.unregisterMBean(this.profilerName);
        }
    }

    protected void unregisterMeQuietly() {
        try {
            this.muleContext.getRegistry().unregisterAgent(this.getName());
        }
        catch (MuleException muleException) {
            // empty catch block
        }
    }

    private boolean isApiAvailable() {
        try {
            ClassUtils.getClass((String)"com.yourkit.api.Controller");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public void start() throws MuleException {
    }

    public void stop() throws MuleException {
    }

    public void dispose() {
        try {
            this.unregisterMBeansIfNecessary();
        }
        catch (Exception e) {
            logger.error((Object)("Couldn't unregister MBean: " + (this.profilerName != null ? this.profilerName.getCanonicalName() : "null")), (Throwable)e);
        }
    }

    public void registered() {
    }

    public void unregistered() {
    }
}

