/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.agents;

import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ExportException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.impl.AbstractAgent;
import org.mule.umo.UMOException;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.util.StringUtils;

public class RmiRegistryAgent
extends AbstractAgent {
    protected transient Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    public static final String DEFAULT_HOSTNAME = "localhost";
    public static final int DEFAULT_PORT = 1099;
    private static final String PROTOCOL_PREFIX = "rmi://";
    public static final String DEFAULT_SERVER_URI = "rmi://localhost:1099";
    private Registry rmiRegistry;
    private String serverUri;
    private String host;
    private String port;
    private boolean createRegistry = true;

    public RmiRegistryAgent() {
        super("RMI Agent");
    }

    public String getDescription() {
        return "Rmi Registry: " + this.serverUri;
    }

    public void registered() {
    }

    public void unregistered() {
    }

    public void start() throws UMOException {
        URI uri;
        try {
            uri = new URI(this.serverUri);
        }
        catch (URISyntaxException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        if (this.rmiRegistry == null) {
            try {
                if (this.createRegistry) {
                    try {
                        this.rmiRegistry = LocateRegistry.createRegistry(uri.getPort());
                    }
                    catch (ExportException e) {
                        this.logger.info((Object)("Registry on " + this.serverUri + " already bound. Attempting to use that instead"));
                        this.rmiRegistry = LocateRegistry.getRegistry(uri.getHost(), uri.getPort());
                    }
                } else {
                    this.rmiRegistry = LocateRegistry.getRegistry(uri.getHost(), uri.getPort());
                }
            }
            catch (RemoteException e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
    }

    public void stop() throws UMOException {
        this.rmiRegistry = null;
    }

    public void dispose() {
    }

    public void initialise() throws InitialisationException {
        if (StringUtils.isNotBlank((String)this.serverUri)) {
            return;
        }
        this.serverUri = StringUtils.isNotBlank((String)this.host) && StringUtils.isNotBlank((String)this.port) ? PROTOCOL_PREFIX + this.host + ":" + this.port : DEFAULT_SERVER_URI;
    }

    public Registry getRmiRegistry() {
        return this.rmiRegistry;
    }

    public void setRmiRegistry(Registry rmiRegistry) {
        this.rmiRegistry = rmiRegistry;
    }

    public String getServerUri() {
        return this.serverUri;
    }

    public void setServerUri(String serverUri) {
        this.serverUri = serverUri;
    }

    public boolean isCreateRegistry() {
        return this.createRegistry;
    }

    public void setCreateRegistry(boolean createRegistry) {
        this.createRegistry = createRegistry;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }
}

