/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.magento.processors;

import java.util.List;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.config.ConfigurationException;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.common.DefaultResult;
import org.mule.common.FailureType;
import org.mule.common.Result;
import org.mule.common.metadata.ConnectorMetaDataEnabled;
import org.mule.common.metadata.DefaultMetaData;
import org.mule.common.metadata.DefaultPojoMetaDataModel;
import org.mule.common.metadata.DefaultSimpleMetaDataModel;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.OperationMetaDataEnabled;
import org.mule.common.metadata.datatype.DataType;
import org.mule.common.metadata.datatype.DataTypeFactory;
import org.mule.module.magento.MagentoCloudConnector;
import org.mule.module.magento.connectivity.MagentoCloudConnectorConnectionManager;
import org.mule.module.magento.processors.AbstractConnectedProcessor;
import org.mule.security.oauth.callback.ProcessCallback;

public class AddOrderShipmentTrackMessageProcessor
extends AbstractConnectedProcessor
implements MessageProcessor,
OperationMetaDataEnabled {
    protected Object shipmentId;
    protected String _shipmentIdType;
    protected Object carrierCode;
    protected String _carrierCodeType;
    protected Object title;
    protected String _titleType;
    protected Object trackId;
    protected String _trackIdType;

    public AddOrderShipmentTrackMessageProcessor(String operationName) {
        super(operationName);
    }

    public void initialise() throws InitialisationException {
    }

    public void start() throws MuleException {
        super.start();
    }

    public void stop() throws MuleException {
        super.stop();
    }

    public void dispose() {
        super.dispose();
    }

    public void setTrackId(Object value) {
        this.trackId = value;
    }

    public void setTitle(Object value) {
        this.title = value;
    }

    public void setShipmentId(Object value) {
        this.shipmentId = value;
    }

    public void setCarrierCode(Object value) {
        this.carrierCode = value;
    }

    public MuleEvent doProcess(MuleEvent event) throws Exception {
        Object moduleObject = null;
        moduleObject = this.findOrCreate(MagentoCloudConnectorConnectionManager.class, true, event);
        final String _transformedShipmentId = (String)this.evaluateAndTransform(this.getMuleContext(), event, AddOrderShipmentTrackMessageProcessor.class.getDeclaredField("_shipmentIdType").getGenericType(), null, this.shipmentId);
        final String _transformedCarrierCode = (String)this.evaluateAndTransform(this.getMuleContext(), event, AddOrderShipmentTrackMessageProcessor.class.getDeclaredField("_carrierCodeType").getGenericType(), null, this.carrierCode);
        final String _transformedTitle = (String)this.evaluateAndTransform(this.getMuleContext(), event, AddOrderShipmentTrackMessageProcessor.class.getDeclaredField("_titleType").getGenericType(), null, this.title);
        final String _transformedTrackId = (String)this.evaluateAndTransform(this.getMuleContext(), event, AddOrderShipmentTrackMessageProcessor.class.getDeclaredField("_trackIdType").getGenericType(), null, this.trackId);
        ProcessTemplate processTemplate = ((ProcessAdapter)moduleObject).getProcessTemplate();
        Object resultPayload = processTemplate.execute((ProcessCallback)new ProcessCallback<Object, Object>(){

            public List<Class<? extends Exception>> getManagedExceptions() {
                return null;
            }

            public boolean isProtected() {
                return false;
            }

            public Object process(Object object) throws Exception {
                return ((MagentoCloudConnector)object).addOrderShipmentTrack(_transformedShipmentId, _transformedCarrierCode, _transformedTitle, _transformedTrackId);
            }
        }, (MessageProcessor)this, event);
        event.getMessage().setPayload(resultPayload);
        return event;
    }

    public Result<MetaData> getInputMetaData() {
        return new DefaultResult(null, Result.Status.SUCCESS);
    }

    public Result<MetaData> getOutputMetaData(MetaData inputMetadata) {
        return new DefaultResult((Object)new DefaultMetaData(this.getPojoOrSimpleModel(Integer.TYPE)));
    }

    private MetaDataModel getPojoOrSimpleModel(Class clazz) {
        DataType dataType = DataTypeFactory.getInstance().getDataType(clazz);
        if (DataType.POJO.equals((Object)dataType)) {
            return new DefaultPojoMetaDataModel(clazz);
        }
        return new DefaultSimpleMetaDataModel(dataType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result<MetaData> getGenericMetaData(MetaDataKey metaDataKey) {
        try {
            ConnectorMetaDataEnabled connector = (ConnectorMetaDataEnabled)this.findOrCreate(MagentoCloudConnectorConnectionManager.class, true, null);
            try {
                Result metadata = connector.getMetaData(metaDataKey);
                if (Result.Status.FAILURE.equals((Object)metadata.getStatus())) {
                    return metadata;
                }
                if (metadata.get() == null) {
                    return new DefaultResult(null, Result.Status.FAILURE, "There was an error processing metadata at MagentoCloudConnector at addOrderShipmentTrack retrieving was successful but result is null");
                }
                return metadata;
            }
            catch (Exception e) {
                return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
            }
        }
        catch (ClassCastException cast) {
            return new DefaultResult(null, Result.Status.FAILURE, "There was an error getting metadata, there was no connection manager available. Maybe you're trying to use metadata from an Oauth connector");
        }
        catch (ConfigurationException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (RegistrationException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (InstantiationException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (Exception e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
    }
}

