/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.magento.process;

import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.devkit.ProcessInterceptor;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.devkit.processor.ExpressionEvaluatorSupport;
import org.mule.module.magento.adapters.MagentoCloudConnectorConnectionIdentifierAdapter;
import org.mule.module.magento.connection.ConnectionManager;
import org.mule.module.magento.connection.UnableToAcquireConnectionException;
import org.mule.module.magento.connection.UnableToReleaseConnectionException;
import org.mule.module.magento.connectivity.MagentoCloudConnectorConnectionKey;
import org.mule.module.magento.processors.ConnectivityProcessor;
import org.mule.security.oauth.callback.ProcessCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MagentoCloudConnectorManagedConnectionProcessInterceptor<T>
extends ExpressionEvaluatorSupport
implements ProcessInterceptor<T, MagentoCloudConnectorConnectionIdentifierAdapter> {
    private static Logger logger = LoggerFactory.getLogger(MagentoCloudConnectorManagedConnectionProcessInterceptor.class);
    private final ConnectionManager<MagentoCloudConnectorConnectionKey, MagentoCloudConnectorConnectionIdentifierAdapter> connectionManager;
    private final MuleContext muleContext;
    private final ProcessInterceptor<T, MagentoCloudConnectorConnectionIdentifierAdapter> next;

    public MagentoCloudConnectorManagedConnectionProcessInterceptor(ProcessInterceptor<T, MagentoCloudConnectorConnectionIdentifierAdapter> next, ConnectionManager<MagentoCloudConnectorConnectionKey, MagentoCloudConnectorConnectionIdentifierAdapter> connectionManager, MuleContext muleContext) {
        this.next = next;
        this.connectionManager = connectionManager;
        this.muleContext = muleContext;
    }

    public T execute(ProcessCallback<T, MagentoCloudConnectorConnectionIdentifierAdapter> processCallback, MagentoCloudConnectorConnectionIdentifierAdapter object, MessageProcessor messageProcessor, MuleEvent event) throws Exception {
        Object connectivityProcessor;
        MagentoCloudConnectorConnectionIdentifierAdapter connection = null;
        MagentoCloudConnectorConnectionKey key = null;
        if (this.hasConnectionKeysOverride(messageProcessor).booleanValue()) {
            connectivityProcessor = (ConnectivityProcessor)messageProcessor;
            String _transformedUsername = (String)this.evaluateAndTransform(this.muleContext, event, connectivityProcessor.typeFor("_usernameType"), null, connectivityProcessor.getUsername());
            if (_transformedUsername == null) {
                throw new UnableToAcquireConnectionException("Parameter username in method initialiseConnector can't be null because is not @Optional");
            }
            String _transformedPassword = (String)this.evaluateAndTransform(this.muleContext, event, connectivityProcessor.typeFor("_passwordType"), null, connectivityProcessor.getPassword());
            if (_transformedPassword == null) {
                throw new UnableToAcquireConnectionException("Parameter password in method initialiseConnector can't be null because is not @Optional");
            }
            String _transformedAddress = (String)this.evaluateAndTransform(this.muleContext, event, connectivityProcessor.typeFor("_addressType"), null, connectivityProcessor.getAddress());
            if (_transformedAddress == null) {
                throw new UnableToAcquireConnectionException("Parameter address in method initialiseConnector can't be null because is not @Optional");
            }
            key = new MagentoCloudConnectorConnectionKey(_transformedUsername, _transformedPassword, _transformedAddress);
        } else {
            key = this.connectionManager.getEvaluatedConnectionKey(event);
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Attempting to acquire connection using " + key.toString());
            }
            if ((connection = this.connectionManager.acquireConnection(key)) == null) {
                throw new UnableToAcquireConnectionException();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Connection has been acquired with [id=" + connection.getConnectionIdentifier() + "]");
            }
            connectivityProcessor = this.next.execute(processCallback, (Object)connection, messageProcessor, event);
            return (T)connectivityProcessor;
        }
        catch (Exception e) {
            if (processCallback.getManagedExceptions() != null) {
                for (Class exceptionClass : processCallback.getManagedExceptions()) {
                    if (!exceptionClass.isInstance(e)) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug("An exception ( " + exceptionClass.getName() + ") has been thrown. Destroying the connection with [id=" + connection.getConnectionIdentifier() + "]");
                    }
                    try {
                        if (connection == null) continue;
                        this.connectionManager.destroyConnection(key, connection);
                        connection = null;
                    }
                    catch (Exception innerException) {
                        logger.error(innerException.getMessage(), (Throwable)innerException);
                    }
                }
            }
            throw e;
        }
        finally {
            try {
                if (connection != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Releasing the connection back into the pool [id=" + connection.getConnectionIdentifier() + "]");
                    }
                    this.connectionManager.releaseConnection(key, connection);
                }
            }
            catch (Exception e) {
                throw new UnableToReleaseConnectionException(e);
            }
        }
    }

    private Boolean hasConnectionKeysOverride(MessageProcessor messageProcessor) {
        if (messageProcessor == null || !(messageProcessor instanceof ConnectivityProcessor)) {
            return false;
        }
        ConnectivityProcessor connectivityProcessor = (ConnectivityProcessor)messageProcessor;
        if (connectivityProcessor.getUsername() != null) {
            return true;
        }
        return false;
    }

    public T execute(ProcessCallback<T, MagentoCloudConnectorConnectionIdentifierAdapter> processCallback, MagentoCloudConnectorConnectionIdentifierAdapter object, Filter filter, MuleMessage message) throws Exception {
        throw new UnsupportedOperationException();
    }
}

