/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.magento.filters;

import com.magento.api.AssociativeEntity;
import com.magento.api.ComplexFilter;
import com.magento.api.Filters;
import java.util.LinkedList;
import java.util.List;

public class FiltersBuilder {
    private List<ComplexFilter> complexFilters = new LinkedList<ComplexFilter>();

    public void addBinaryExpression(String operation, String variable, String value) {
        this.complexFilters.add(new ComplexFilter(variable, new AssociativeEntity(operation, this.convertValue(value))));
    }

    private String convertValue(String value) {
        if (value.length() >= 2 && value.charAt(0) == '\'' && value.charAt(value.length() - 1) == '\'') {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    public void addUnaryExpression(String operation, String variable) {
        if (operation.equals("istrue")) {
            this.addBinaryExpression("eq", variable, "1");
        } else if (operation.equals("isfalse")) {
            this.addBinaryExpression("eq", variable, "0");
        } else {
            this.addBinaryExpression(operation, variable, "");
        }
    }

    public Filters build() {
        return new Filters(null, this.complexFilters.toArray(new ComplexFilter[this.complexFilters.size()]));
    }
}

