/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.magento.connectivity;

import java.util.List;
import org.apache.commons.pool.KeyedObjectPool;
import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.mule.api.MetadataAware;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.MuleContextAware;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.devkit.capability.Capabilities;
import org.mule.api.devkit.capability.ModuleCapability;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.common.DefaultResult;
import org.mule.common.DefaultTestResult;
import org.mule.common.FailureType;
import org.mule.common.Result;
import org.mule.common.TestResult;
import org.mule.common.Testable;
import org.mule.common.metadata.ConnectorMetaDataEnabled;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataFailureType;
import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.NativeQueryMetadataTranslator;
import org.mule.common.query.DsqlQuery;
import org.mule.common.query.Query;
import org.mule.config.PoolingProfile;
import org.mule.devkit.processor.ExpressionEvaluatorSupport;
import org.mule.module.magento.adapters.MagentoCloudConnectorConnectionIdentifierAdapter;
import org.mule.module.magento.connection.ConnectionManager;
import org.mule.module.magento.connection.UnableToAcquireConnectionException;
import org.mule.module.magento.connectivity.MagentoCloudConnectorConnectionFactory;
import org.mule.module.magento.connectivity.MagentoCloudConnectorConnectionKey;
import org.mule.module.magento.connectivity.MagentoCloudConnectorManagedConnectionProcessTemplate;
import org.mule.module.magento.pooling.DevkitGenericKeyedObjectPool;

public class MagentoCloudConnectorConnectionManager
extends ExpressionEvaluatorSupport
implements MetadataAware,
MuleContextAware,
ProcessAdapter<MagentoCloudConnectorConnectionIdentifierAdapter>,
Capabilities,
Disposable,
Initialisable,
Testable,
ConnectorMetaDataEnabled,
NativeQueryMetadataTranslator,
ConnectionManager<MagentoCloudConnectorConnectionKey, MagentoCloudConnectorConnectionIdentifierAdapter> {
    private String username;
    private String password;
    private String address;
    protected MuleContext muleContext;
    protected FlowConstruct flowConstruct;
    private KeyedObjectPool connectionPool;
    protected PoolingProfile poolingProfile;
    protected RetryPolicyTemplate retryPolicyTemplate;
    private static final String MODULE_NAME = "Magento";
    private static final String MODULE_VERSION = "2.2.0";
    private static final String DEVKIT_VERSION = "3.5.3";
    private static final String DEVKIT_BUILD = "UNNAMED.2049.ec39f2b";
    private static final String MIN_MULE_VERSION = "3.5";

    public void setMuleContext(MuleContext value) {
        this.muleContext = value;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public void setFlowConstruct(FlowConstruct value) {
        this.flowConstruct = value;
    }

    public FlowConstruct getFlowConstruct() {
        return this.flowConstruct;
    }

    public void setPoolingProfile(PoolingProfile value) {
        this.poolingProfile = value;
    }

    public PoolingProfile getPoolingProfile() {
        return this.poolingProfile;
    }

    public void setRetryPolicyTemplate(RetryPolicyTemplate value) {
        this.retryPolicyTemplate = value;
    }

    @Override
    public RetryPolicyTemplate getRetryPolicyTemplate() {
        return this.retryPolicyTemplate;
    }

    public void setUsername(String value) {
        this.username = value;
    }

    public String getUsername() {
        return this.username;
    }

    public void setAddress(String value) {
        this.address = value;
    }

    public String getAddress() {
        return this.address;
    }

    public void setPassword(String value) {
        this.password = value;
    }

    public String getPassword() {
        return this.password;
    }

    public void initialise() {
        this.connectionPool = new DevkitGenericKeyedObjectPool(new MagentoCloudConnectorConnectionFactory(this), this.poolingProfile);
        if (this.retryPolicyTemplate == null) {
            this.retryPolicyTemplate = (RetryPolicyTemplate)this.muleContext.getRegistry().lookupObject("_defaultRetryPolicyTemplate");
        }
    }

    public void dispose() {
        try {
            this.connectionPool.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public MagentoCloudConnectorConnectionIdentifierAdapter acquireConnection(MagentoCloudConnectorConnectionKey key) throws Exception {
        return (MagentoCloudConnectorConnectionIdentifierAdapter)this.connectionPool.borrowObject((Object)key);
    }

    @Override
    public void releaseConnection(MagentoCloudConnectorConnectionKey key, MagentoCloudConnectorConnectionIdentifierAdapter connection) throws Exception {
        this.connectionPool.returnObject((Object)key, (Object)connection);
    }

    @Override
    public void destroyConnection(MagentoCloudConnectorConnectionKey key, MagentoCloudConnectorConnectionIdentifierAdapter connection) throws Exception {
        this.connectionPool.invalidateObject((Object)key, (Object)connection);
    }

    public boolean isCapableOf(ModuleCapability capability) {
        if (capability == ModuleCapability.LIFECYCLE_CAPABLE) {
            return true;
        }
        return capability == ModuleCapability.CONNECTION_MANAGEMENT_CAPABLE;
    }

    public <P> ProcessTemplate<P, MagentoCloudConnectorConnectionIdentifierAdapter> getProcessTemplate() {
        return new MagentoCloudConnectorManagedConnectionProcessTemplate(this, this.muleContext);
    }

    @Override
    public MagentoCloudConnectorConnectionKey getDefaultConnectionKey() {
        return new MagentoCloudConnectorConnectionKey(this.getUsername(), this.getPassword(), this.getAddress());
    }

    @Override
    public MagentoCloudConnectorConnectionKey getEvaluatedConnectionKey(MuleEvent event) throws Exception {
        if (event != null) {
            String _transformedUsername = (String)this.evaluateAndTransform(this.muleContext, event, this.getClass().getDeclaredField("username").getGenericType(), null, this.getUsername());
            if (_transformedUsername == null) {
                throw new UnableToAcquireConnectionException("Parameter username in method initialiseConnector can't be null because is not @Optional");
            }
            String _transformedPassword = (String)this.evaluateAndTransform(this.muleContext, event, this.getClass().getDeclaredField("password").getGenericType(), null, this.getPassword());
            if (_transformedPassword == null) {
                throw new UnableToAcquireConnectionException("Parameter password in method initialiseConnector can't be null because is not @Optional");
            }
            String _transformedAddress = (String)this.evaluateAndTransform(this.muleContext, event, this.getClass().getDeclaredField("address").getGenericType(), null, this.getAddress());
            if (_transformedAddress == null) {
                throw new UnableToAcquireConnectionException("Parameter address in method initialiseConnector can't be null because is not @Optional");
            }
            return new MagentoCloudConnectorConnectionKey(_transformedUsername, _transformedPassword, _transformedAddress);
        }
        return this.getDefaultConnectionKey();
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public String getModuleVersion() {
        return MODULE_VERSION;
    }

    public String getDevkitVersion() {
        return DEVKIT_VERSION;
    }

    public String getDevkitBuild() {
        return DEVKIT_BUILD;
    }

    public String getMinMuleVersion() {
        return MIN_MULE_VERSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResult test() {
        DefaultTestResult result;
        MagentoCloudConnectorConnectionIdentifierAdapter connection = null;
        MagentoCloudConnectorConnectionKey key = this.getDefaultConnectionKey();
        try {
            connection = this.acquireConnection(key);
            result = new DefaultTestResult(Result.Status.SUCCESS);
        }
        catch (Exception e) {
            try {
                this.destroyConnection(key, connection);
            }
            catch (Exception ie) {
                // empty catch block
            }
            result = (DefaultTestResult)this.buildFailureTestResult(e);
        }
        finally {
            if (connection != null) {
                try {
                    this.releaseConnection(key, connection);
                }
                catch (Exception ie) {}
            }
        }
        return result;
    }

    public DefaultResult buildFailureTestResult(Exception exception) {
        ConnectionExceptionCode code;
        DefaultTestResult result = exception instanceof ConnectionException ? ((code = ((ConnectionException)exception).getCode()) == ConnectionExceptionCode.UNKNOWN_HOST ? new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.UNKNOWN_HOST, (Throwable)exception) : (code == ConnectionExceptionCode.CANNOT_REACH ? new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.RESOURCE_UNAVAILABLE, (Throwable)exception) : (code == ConnectionExceptionCode.INCORRECT_CREDENTIALS ? new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.INVALID_CREDENTIALS, (Throwable)exception) : (code == ConnectionExceptionCode.CREDENTIALS_EXPIRED ? new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.INVALID_CREDENTIALS, (Throwable)exception) : (code == ConnectionExceptionCode.UNKNOWN ? new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.UNSPECIFIED, (Throwable)exception) : new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.UNSPECIFIED, (Throwable)exception)))))) : new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.UNSPECIFIED, (Throwable)exception);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Result<List<MetaDataKey>> getMetaDataKeys() {
        MagentoCloudConnectorConnectionIdentifierAdapter connection = null;
        MagentoCloudConnectorConnectionKey key = this.getDefaultConnectionKey();
        try {
            connection = this.acquireConnection(key);
            try {
                DefaultResult defaultResult = new DefaultResult(connection.getMetadataKeys(), Result.Status.SUCCESS);
                return defaultResult;
            }
            catch (Exception e) {
                DefaultResult ie;
                block19: {
                    ie = new DefaultResult(null, Result.Status.FAILURE, "There was an error retrieving the metadata keys from service provider after acquiring connection, for more detailed information please read the provided stacktrace", (FailureType)MetaDataFailureType.ERROR_METADATA_KEYS_RETRIEVER, (Throwable)e);
                    if (connection == null) break block19;
                    try {
                        this.releaseConnection(key, connection);
                    }
                    catch (Exception ie2) {
                        // empty catch block
                    }
                }
                return ie;
                catch (Exception e2) {
                    try {
                        this.destroyConnection(key, connection);
                    }
                    catch (Exception ie3) {
                        // empty catch block
                    }
                    DefaultResult defaultResult = this.buildFailureTestResult(e2);
                    return defaultResult;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (connection != null) {
                try {
                    this.releaseConnection(key, connection);
                }
                catch (Exception ie) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Result<MetaData> getMetaData(MetaDataKey metaDataKey) {
        MagentoCloudConnectorConnectionIdentifierAdapter connection = null;
        MagentoCloudConnectorConnectionKey key = this.getDefaultConnectionKey();
        try {
            connection = this.acquireConnection(key);
            try {
                DefaultResult defaultResult = new DefaultResult((Object)connection.getMetadata(metaDataKey));
                return defaultResult;
            }
            catch (Exception e) {
                DefaultResult ie;
                block19: {
                    ie = new DefaultResult(null, Result.Status.FAILURE, this.getMetaDataException(metaDataKey), (FailureType)MetaDataFailureType.ERROR_METADATA_RETRIEVER, (Throwable)e);
                    if (connection == null) break block19;
                    try {
                        this.releaseConnection(key, connection);
                    }
                    catch (Exception ie2) {
                        // empty catch block
                    }
                }
                return ie;
                catch (Exception e2) {
                    try {
                        this.destroyConnection(key, connection);
                    }
                    catch (Exception ie3) {
                        // empty catch block
                    }
                    DefaultResult defaultResult = this.buildFailureTestResult(e2);
                    return defaultResult;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (connection != null) {
                try {
                    this.releaseConnection(key, connection);
                }
                catch (Exception ie) {}
            }
        }
    }

    private String getMetaDataException(MetaDataKey key) {
        if (key != null && key.getId() != null) {
            return "There was an error retrieving metadata from key: " + key.getId() + " after acquiring the connection, for more detailed information please read the provided stacktrace";
        }
        return "There was an error retrieving metadata after acquiring the connection, MetaDataKey is null or its id is null, for more detailed information please read the provided stacktrace";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result<String> toNativeQuery(DsqlQuery query) {
        DefaultResult result;
        MagentoCloudConnectorConnectionIdentifierAdapter connection = null;
        MagentoCloudConnectorConnectionKey key = this.getDefaultConnectionKey();
        try {
            connection = this.acquireConnection(key);
            result = new DefaultResult((Object)connection.toNativeQuery((Query)query).toString());
        }
        catch (Exception e) {
            try {
                this.destroyConnection(key, connection);
            }
            catch (Exception ie) {
                // empty catch block
            }
            result = new DefaultResult(null, Result.Status.FAILURE, e.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    this.releaseConnection(key, connection);
                }
                catch (Exception ie) {}
            }
        }
        return result;
    }
}

