/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.magento.config;

import com.magento.api.holders.CustomerAddressEntityCreateExpressionHolder;
import org.mule.config.MuleManifest;
import org.mule.module.magento.processors.UpdateCustomerAddressMessageProcessor;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class UpdateCustomerAddressDefinitionParser
extends AbstractDevkitBasedDefinitionParser {
    private static Logger logger = LoggerFactory.getLogger(UpdateCustomerAddressDefinitionParser.class);

    private BeanDefinitionBuilder getBeanDefinitionBuilder(ParserContext parserContext) {
        try {
            return BeanDefinitionBuilder.rootBeanDefinition((String)UpdateCustomerAddressMessageProcessor.class.getName());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            String muleVersion = "";
            try {
                muleVersion = MuleManifest.getProductVersion();
            }
            catch (Exception _x) {
                logger.error("Problem while reading mule version");
            }
            logger.error("Cannot launch the mule app, the @Processor [update-customer-address] within the connector [magento] is not supported in mule " + muleVersion);
            throw new BeanDefinitionParsingException(new Problem("Cannot launch the mule app, the @Processor [update-customer-address] within the connector [magento] is not supported in mule " + muleVersion, new Location(parserContext.getReaderContext().getResource()), null, (Throwable)noClassDefFoundError));
        }
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = this.getBeanDefinitionBuilder(parserContext);
        builder.addConstructorArgValue((Object)"updateCustomerAddress");
        builder.setScope("prototype");
        this.parseConfigRef(element, builder);
        this.parseProperty(builder, element, "addressId", "addressId");
        if (!this.parseObjectRefWithDefault(element, builder, "customer-address", "customerAddress", "#[payload]")) {
            BeanDefinitionBuilder customerAddressBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)CustomerAddressEntityCreateExpressionHolder.class.getName());
            Element customerAddressChildElement = DomUtils.getChildElementByTagName((Element)element, (String)"customer-address");
            if (customerAddressChildElement != null) {
                this.parseProperty(customerAddressBuilder, customerAddressChildElement, "city", "city");
                this.parseProperty(customerAddressBuilder, customerAddressChildElement, "company", "company");
                this.parseProperty(customerAddressBuilder, customerAddressChildElement, "country_id", "country_id");
                this.parseProperty(customerAddressBuilder, customerAddressChildElement, "fax", "fax");
                this.parseProperty(customerAddressBuilder, customerAddressChildElement, "firstname", "firstname");
                this.parseProperty(customerAddressBuilder, customerAddressChildElement, "lastname", "lastname");
                this.parseProperty(customerAddressBuilder, customerAddressChildElement, "middlename", "middlename");
                this.parseProperty(customerAddressBuilder, customerAddressChildElement, "postcode", "postcode");
                this.parseProperty(customerAddressBuilder, customerAddressChildElement, "prefix", "prefix");
                this.parseProperty(customerAddressBuilder, customerAddressChildElement, "region_id", "region_id");
                this.parseProperty(customerAddressBuilder, customerAddressChildElement, "region", "region");
                if (this.hasAttribute(customerAddressChildElement, "street-ref")) {
                    if (customerAddressChildElement.getAttribute("street-ref").startsWith("#")) {
                        customerAddressBuilder.addPropertyValue("street", (Object)customerAddressChildElement.getAttribute("street-ref"));
                    } else {
                        customerAddressBuilder.addPropertyValue("street", (Object)("#[registry:" + customerAddressChildElement.getAttribute("street-ref") + "]"));
                    }
                }
                this.parseProperty(customerAddressBuilder, customerAddressChildElement, "suffix", "suffix");
                this.parseProperty(customerAddressBuilder, customerAddressChildElement, "telephone", "telephone");
                this.parseProperty(customerAddressBuilder, customerAddressChildElement, "is_default_billing", "is_default_billing");
                this.parseProperty(customerAddressBuilder, customerAddressChildElement, "is_default_shipping", "is_default_shipping");
                builder.addPropertyValue("customerAddress", (Object)customerAddressBuilder.getBeanDefinition());
            }
        }
        this.parseProperty(builder, element, "username", "username");
        this.parseProperty(builder, element, "password", "password");
        this.parseProperty(builder, element, "address", "address");
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        this.setNoRecurseOnDefinition((BeanDefinition)definition);
        this.attachProcessorDefinition(parserContext, (BeanDefinition)definition);
        return definition;
    }
}

