/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.magento.api.shoppingCart;

import com.magento.api.CatalogProductEntity;
import com.magento.api.ShoppingCartCustomerAddressEntity;
import com.magento.api.ShoppingCartCustomerEntity;
import com.magento.api.ShoppingCartInfoEntity;
import com.magento.api.ShoppingCartLicenseEntity;
import com.magento.api.ShoppingCartPaymentMethodEntity;
import com.magento.api.ShoppingCartPaymentMethodResponseEntityArray;
import com.magento.api.ShoppingCartProductEntity;
import com.magento.api.ShoppingCartShippingMethodEntity;
import com.magento.api.ShoppingCartTotalsEntity;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;
import org.mule.module.magento.api.AbstractMagentoClient;
import org.mule.module.magento.api.AxisPortProvider;
import org.mule.module.magento.api.shoppingCart.MagentoShoppingCartClient;

public class AxisMagentoShoppingCartClient
extends AbstractMagentoClient
implements MagentoShoppingCartClient<RemoteException> {
    public AxisMagentoShoppingCartClient(AxisPortProvider provider) {
        super(provider);
    }

    @Override
    public int createShoppingCart(String storeId) throws RemoteException {
        return this.getPort().shoppingCartCreate(this.getSessionId(), storeId);
    }

    @Override
    public ShoppingCartInfoEntity getShoppingCartInfo(int quoteId, String storeId) throws RemoteException {
        return this.getPort().shoppingCartInfo(this.getSessionId(), quoteId, storeId);
    }

    @Override
    public List<ShoppingCartTotalsEntity> listShoppingCartTotals(int quoteId, String storeId) throws RemoteException {
        return Arrays.asList(this.getPort().shoppingCartTotals(this.getSessionId(), quoteId, storeId));
    }

    @Override
    public String createShoppingCartOrder(int quoteId, String storeId, List<String> licenses) throws RemoteException {
        return this.getPort().shoppingCartOrder(this.getSessionId(), quoteId, storeId, licenses == null ? null : AxisMagentoShoppingCartClient.toArray(licenses, String.class));
    }

    @Override
    public List<ShoppingCartLicenseEntity> listShoppingCartLicenses(int quoteId, String storeId) throws RemoteException {
        return Arrays.asList(this.getPort().shoppingCartLicense(this.getSessionId(), quoteId, storeId));
    }

    @Override
    public boolean addShoppingCartProduct(int quoteId, List<ShoppingCartProductEntity> products, String storeId) throws RemoteException {
        return this.getPort().shoppingCartProductAdd(this.getSessionId(), quoteId, products.toArray(new ShoppingCartProductEntity[products.size()]), storeId);
    }

    @Override
    public boolean updateShoppingCartProduct(int quoteId, List<ShoppingCartProductEntity> products, String storeId) throws RemoteException {
        return this.getPort().shoppingCartProductUpdate(this.getSessionId(), quoteId, products.toArray(new ShoppingCartProductEntity[products.size()]), storeId);
    }

    @Override
    public boolean removeShoppingCartProduct(int quoteId, List<ShoppingCartProductEntity> products, String storeId) throws RemoteException {
        return this.getPort().shoppingCartProductRemove(this.getSessionId(), quoteId, products.toArray(new ShoppingCartProductEntity[products.size()]), storeId);
    }

    @Override
    public List<CatalogProductEntity> listShoppingCartProducts(int quoteId, String storeId) throws RemoteException {
        return Arrays.asList(this.getPort().shoppingCartProductList(this.getSessionId(), quoteId, storeId));
    }

    @Override
    public boolean moveShoppingCartProductToCustomerQuote(int quoteId, List<ShoppingCartProductEntity> products, String storeId) throws RemoteException {
        return this.getPort().shoppingCartProductMoveToCustomerQuote(this.getSessionId(), quoteId, products.toArray(new ShoppingCartProductEntity[products.size()]), storeId);
    }

    @Override
    public boolean setShoppingCartCustomer(int quoteId, ShoppingCartCustomerEntity customer, String storeId) throws RemoteException {
        return this.getPort().shoppingCartCustomerSet(this.getSessionId(), quoteId, customer, storeId);
    }

    @Override
    public boolean setShoppingCartCustomerAddresses(int quoteId, List<ShoppingCartCustomerAddressEntity> addresses, String storeId) throws RemoteException {
        return this.getPort().shoppingCartCustomerAddresses(this.getSessionId(), quoteId, addresses.toArray(new ShoppingCartCustomerAddressEntity[addresses.size()]), storeId);
    }

    @Override
    public boolean setShoppingCartShippingMethod(int quoteId, String method, String storeId) throws RemoteException {
        return this.getPort().shoppingCartShippingMethod(this.getSessionId(), quoteId, method, storeId);
    }

    @Override
    public List<ShoppingCartShippingMethodEntity> listShoppingCartShippingMethods(int quoteId, String storeId) throws RemoteException {
        return Arrays.asList(this.getPort().shoppingCartShippingList(this.getSessionId(), quoteId, storeId));
    }

    @Override
    public boolean setShoppingCartPaymentMethod(int quoteId, ShoppingCartPaymentMethodEntity method, String storeId) throws RemoteException {
        return this.getPort().shoppingCartPaymentMethod(this.getSessionId(), quoteId, method, storeId);
    }

    @Override
    public ShoppingCartPaymentMethodResponseEntityArray listShoppingCartPaymentMethods(int quoteId, String storeId) throws RemoteException {
        return this.getPort().shoppingCartPaymentList(this.getSessionId(), quoteId, storeId);
    }

    @Override
    public boolean addShoppingCartCoupon(int quoteId, String couponCode, String storeId) throws RemoteException {
        return this.getPort().shoppingCartCouponAdd(this.getSessionId(), quoteId, couponCode, storeId);
    }

    @Override
    public boolean removeShoppingCartCoupon(int quoteId, String storeId) throws RemoteException {
        return this.getPort().shoppingCartCouponRemove(this.getSessionId(), quoteId, storeId);
    }
}

