/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.magento.api.order;

import com.magento.api.AssociativeEntity;
import com.magento.api.OrderItemIdQty;
import com.magento.api.SalesOrderEntity;
import com.magento.api.SalesOrderInvoiceEntity;
import com.magento.api.SalesOrderListEntity;
import com.magento.api.SalesOrderShipmentEntity;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.Validate;
import org.mule.module.magento.api.AbstractMagentoClient;
import org.mule.module.magento.api.AxisPortProvider;
import org.mule.module.magento.api.order.MagentoOrderClient;
import org.mule.module.magento.api.order.model.Carrier;
import org.mule.module.magento.filters.FiltersParser;

public class AxisMagentoOrderClient
extends AbstractMagentoClient
implements MagentoOrderClient<RemoteException> {
    public AxisMagentoOrderClient(AxisPortProvider provider) {
        super(provider);
    }

    @Override
    public List<SalesOrderListEntity> listOrders(String filter) throws RemoteException {
        return Arrays.asList(this.getPort().salesOrderList(this.getSessionId(), FiltersParser.parse(filter)));
    }

    @Override
    public SalesOrderEntity getOrder(String orderId) throws RemoteException {
        return this.getPort().salesOrderInfo(this.getSessionId(), orderId);
    }

    @Override
    public boolean holdOrder(String orderId) throws RemoteException {
        return this.getPort().salesOrderHold(this.getSessionId(), orderId);
    }

    @Override
    public boolean unholdOrder(@NotNull String orderId) throws RemoteException {
        Validate.notNull((Object)orderId);
        return this.getPort().salesOrderUnhold(this.getSessionId(), orderId);
    }

    @Override
    public boolean cancelOrder(@NotNull String orderId) throws RemoteException {
        Validate.notNull((Object)orderId);
        return this.getPort().salesOrderCancel(this.getSessionId(), orderId);
    }

    @Override
    public boolean addOrderComment(@NotNull String orderId, @NotNull String status, @NotNull String comment, boolean sendEmail) throws RemoteException {
        Validate.notNull((Object)orderId);
        Validate.notNull((Object)status);
        Validate.notNull((Object)comment);
        return this.getPort().salesOrderAddComment(this.getSessionId(), orderId, status, comment, AxisMagentoOrderClient.toIntegerString(sendEmail));
    }

    @Override
    @NotNull
    public List<SalesOrderShipmentEntity> listOrdersShipments(String filter) throws RemoteException {
        return Arrays.asList(this.getPort().salesOrderShipmentList(this.getSessionId(), FiltersParser.parse(filter)));
    }

    @Override
    public SalesOrderShipmentEntity getOrderShipment(String shipmentId) throws RemoteException {
        return this.getPort().salesOrderShipmentInfo(this.getSessionId(), shipmentId);
    }

    @Override
    public boolean addOrderShipmentComment(@NotNull String shipmentId, String comment, boolean sendEmail, boolean includeCommentInEmail) throws RemoteException {
        Validate.notNull((Object)shipmentId);
        Validate.notNull((Object)comment);
        return this.getPort().salesOrderShipmentAddComment(this.getSessionId(), shipmentId, comment, AxisMagentoOrderClient.toIntegerString(sendEmail), AxisMagentoOrderClient.toIntegerString(includeCommentInEmail));
    }

    @Override
    @NotNull
    public List<Carrier> getOrderShipmentCarriers(@NotNull String orderId) throws RemoteException {
        Validate.notNull((Object)orderId);
        return (List)CollectionUtils.collect(Arrays.asList(this.getPort().salesOrderShipmentGetCarriers(this.getSessionId(), orderId)), (Transformer)new Transformer(){

            public Object transform(Object input) {
                AssociativeEntity entity = (AssociativeEntity)input;
                return new Carrier(entity.getKey(), entity.getValue());
            }
        });
    }

    @Override
    public int addOrderShipmentTrack(@NotNull String shipmentId, @NotNull String carrier, @NotNull String title, @NotNull String trackNumber) throws RemoteException {
        Validate.notNull((Object)shipmentId);
        Validate.notNull((Object)carrier);
        Validate.notNull((Object)title);
        Validate.notNull((Object)trackNumber);
        return this.getPort().salesOrderShipmentAddTrack(this.getSessionId(), shipmentId, carrier, title, trackNumber);
    }

    @Override
    public boolean deleteOrderShipmentTrack(@NotNull String shipmentId, @NotNull String trackId) throws RemoteException {
        Validate.notNull((Object)shipmentId);
        Validate.notNull((Object)trackId);
        return this.getPort().salesOrderShipmentRemoveTrack(this.getSessionId(), shipmentId, trackId);
    }

    @Override
    public String createOrderShipment(@NotNull String orderId, List<OrderItemIdQty> itemsQuantities, String comment, boolean sendEmail, boolean includeCommentInEmail) throws RemoteException {
        return this.getPort().salesOrderShipmentCreate(this.getSessionId(), orderId, itemsQuantities == null ? null : itemsQuantities.toArray(new OrderItemIdQty[itemsQuantities.size()]), comment, BooleanUtils.toInteger((boolean)sendEmail), BooleanUtils.toInteger((boolean)includeCommentInEmail));
    }

    @Override
    public List<SalesOrderInvoiceEntity> listOrdersInvoices(String filter) throws RemoteException {
        return Arrays.asList(this.getPort().salesOrderInvoiceList(this.getSessionId(), FiltersParser.parse(filter)));
    }

    @Override
    public SalesOrderInvoiceEntity getOrderInvoice(@NotNull String invoiceId) throws RemoteException {
        Validate.notNull((Object)invoiceId);
        return this.getPort().salesOrderInvoiceInfo(this.getSessionId(), invoiceId);
    }

    @Override
    public String createOrderInvoice(@NotNull String orderId, @NotNull List<OrderItemIdQty> itemsQuantities, String comment, boolean sendEmail, boolean includeCommentInEmail) throws RemoteException {
        Validate.notNull((Object)orderId);
        return this.getPort().salesOrderInvoiceCreate(this.getSessionId(), orderId, itemsQuantities.toArray(new OrderItemIdQty[itemsQuantities.size()]), comment, AxisMagentoOrderClient.toIntegerString(sendEmail), AxisMagentoOrderClient.toIntegerString(includeCommentInEmail));
    }

    @Override
    public boolean addOrderInvoiceComment(@NotNull String invoiceId, @NotNull String comment, boolean sendEmail, boolean includeCommentInEmail) throws RemoteException {
        Validate.notNull((Object)invoiceId);
        Validate.notNull((Object)comment);
        return this.getPort().salesOrderInvoiceAddComment(this.getSessionId(), invoiceId, comment, AxisMagentoOrderClient.toIntegerString(sendEmail), AxisMagentoOrderClient.toIntegerString(includeCommentInEmail));
    }

    @Override
    public void captureOrderInvoice(@NotNull String invoiceId) throws RemoteException {
        Validate.notNull((Object)invoiceId);
        this.getPort().salesOrderInvoiceCapture(this.getSessionId(), invoiceId);
    }

    @Override
    public boolean voidOrderInvoice(@NotNull String invoiceId) throws RemoteException {
        Validate.notNull((Object)invoiceId);
        return this.getPort().salesOrderInvoiceVoid(this.getSessionId(), invoiceId);
    }

    @Override
    public void cancelOrderInvoice(@NotNull String invoiceId) throws RemoteException {
        Validate.notNull((Object)invoiceId);
        this.getPort().salesOrderInvoiceCancel(this.getSessionId(), invoiceId);
    }

    private OrderItemIdQty[] fromMap(Map<Integer, Double> map) {
        OrderItemIdQty[] quantities = new OrderItemIdQty[map.size()];
        int i = 0;
        for (Map.Entry<Integer, Double> entry : map.entrySet()) {
            quantities[i] = new OrderItemIdQty(entry.getKey(), entry.getValue());
            ++i;
        }
        return quantities;
    }
}

