/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.magento.api.inventory;

import com.magento.api.CustomerAddressEntityCreate;
import com.magento.api.CustomerAddressEntityItem;
import com.magento.api.CustomerCustomerEntity;
import com.magento.api.CustomerCustomerEntityToCreate;
import com.magento.api.CustomerGroupEntity;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.Validate;
import org.mule.module.magento.api.AbstractMagentoClient;
import org.mule.module.magento.api.AxisPortProvider;
import org.mule.module.magento.api.inventory.MagentoCustomerClient;
import org.mule.module.magento.filters.FiltersParser;

public class AxisMagentoCustomerClient
extends AbstractMagentoClient
implements MagentoCustomerClient<RemoteException> {
    public AxisMagentoCustomerClient(AxisPortProvider provider) {
        super(provider);
    }

    @Override
    public int createCustomer(@NotNull CustomerCustomerEntityToCreate customerEntityToCreate) throws RemoteException {
        return this.getPort().customerCustomerCreate(this.getSessionId(), customerEntityToCreate);
    }

    @Override
    public boolean deleteCustomer(int customerId) throws RemoteException {
        return this.getPort().customerCustomerDelete(this.getSessionId(), customerId);
    }

    @Override
    @NotNull
    public CustomerCustomerEntity getCustomer(int customerId, @NotNull List<String> attributeNames) throws RemoteException {
        Validate.notEmpty(attributeNames);
        return this.getPort().customerCustomerInfo(this.getSessionId(), customerId, AxisMagentoCustomerClient.toArray(attributeNames, String.class));
    }

    @Override
    @NotNull
    public List<CustomerCustomerEntity> listCustomers(String filters) throws RemoteException {
        return Arrays.asList(this.getPort().customerCustomerList(this.getSessionId(), FiltersParser.parse(filters)));
    }

    @Override
    public boolean updateCustomer(int customerId, @NotNull CustomerCustomerEntityToCreate attributes) throws RemoteException {
        Validate.notNull((Object)attributes);
        return this.getPort().customerCustomerUpdate(this.getSessionId(), customerId, attributes);
    }

    @Override
    public int createCustomerAddress(int customerId, CustomerAddressEntityCreate attributes) throws RemoteException {
        return this.getPort().customerAddressCreate(this.getSessionId(), customerId, attributes);
    }

    @Override
    public boolean deleteCustomerAddress(int addressId) throws RemoteException {
        return this.getPort().customerAddressDelete(this.getSessionId(), addressId);
    }

    @Override
    public CustomerAddressEntityItem getCustomerAddress(int addressId) throws RemoteException {
        return this.getPort().customerAddressInfo(this.getSessionId(), addressId);
    }

    @Override
    public List<CustomerAddressEntityItem> listCustomerAddresses(int customerId) throws RemoteException {
        return Arrays.asList(this.getPort().customerAddressList(this.getSessionId(), customerId));
    }

    @Override
    public boolean updateCustomerAddress(int addressId, CustomerAddressEntityCreate attributes) throws RemoteException {
        return this.getPort().customerAddressUpdate(this.getSessionId(), addressId, attributes);
    }

    @Override
    public List<CustomerGroupEntity> listCustomerGroups() throws RemoteException {
        return Arrays.asList(this.getPort().customerGroupList(this.getSessionId()));
    }
}

