/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.magento.api.customer;

import com.magento.api.CatalogInventoryStockItemEntity;
import com.magento.api.CatalogInventoryStockItemUpdateEntity;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.Validate;
import org.mule.module.magento.api.AbstractMagentoClient;
import org.mule.module.magento.api.AxisPortProvider;
import org.mule.module.magento.api.customer.MagentoInventoryClient;

public class AxisMagentoInventoryClient
extends AbstractMagentoClient
implements MagentoInventoryClient<RemoteException> {
    public AxisMagentoInventoryClient(AxisPortProvider provider) {
        super(provider);
    }

    @Override
    public List<CatalogInventoryStockItemEntity> listStockItems(@NotNull List<String> productIdsOrSkus) throws RemoteException {
        Validate.notNull(productIdsOrSkus);
        Validate.notEmpty(productIdsOrSkus);
        return Arrays.asList(this.getPort().catalogInventoryStockItemList(this.getSessionId(), AxisMagentoInventoryClient.toArray(productIdsOrSkus, String.class)));
    }

    @Override
    public int updateStockItem(@NotNull String productIdOrSkus, @NotNull CatalogInventoryStockItemUpdateEntity attributes) throws RemoteException {
        Validate.notNull((Object)productIdOrSkus);
        Validate.notNull((Object)attributes);
        return this.getPort().catalogInventoryStockItemUpdate(this.getSessionId(), productIdOrSkus, attributes);
    }
}

