/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.magento.api.catalog.model;

public interface ProductIdentifier {
    public String getIdentifierAsString();

    public String getIdentifierType();

    public static class IdOrSku
    implements ProductIdentifier {
        private final String idOrSku;

        public IdOrSku(String sku) {
            this.idOrSku = sku;
        }

        @Override
        public String getIdentifierAsString() {
            return this.idOrSku;
        }

        @Override
        public String getIdentifierType() {
            return null;
        }
    }

    public static class Sku
    implements ProductIdentifier {
        private final String sku;

        public Sku(String sku) {
            this.sku = sku;
        }

        @Override
        public String getIdentifierAsString() {
            return this.sku;
        }

        @Override
        public String getIdentifierType() {
            return "sku";
        }
    }

    public static class Id
    implements ProductIdentifier {
        private final Integer id;

        public Id(Integer id) {
            this.id = id;
        }

        @Override
        public String getIdentifierAsString() {
            return this.id.toString();
        }

        @Override
        public String getIdentifierType() {
            return "id";
        }
    }
}

