/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.magento.api.catalog;

import com.magento.api.AssociativeEntity;
import com.magento.api.CatalogAssignedProduct;
import com.magento.api.CatalogAttributeEntity;
import com.magento.api.CatalogAttributeOptionEntity;
import com.magento.api.CatalogCategoryEntityCreate;
import com.magento.api.CatalogCategoryEntityNoChildren;
import com.magento.api.CatalogCategoryInfo;
import com.magento.api.CatalogCategoryTree;
import com.magento.api.CatalogInventoryStockItemEntity;
import com.magento.api.CatalogInventoryStockItemUpdateEntity;
import com.magento.api.CatalogProductAdditionalAttributesEntity;
import com.magento.api.CatalogProductAttributeMediaCreateEntity;
import com.magento.api.CatalogProductAttributeMediaTypeEntity;
import com.magento.api.CatalogProductAttributeSetEntity;
import com.magento.api.CatalogProductCreateEntity;
import com.magento.api.CatalogProductEntity;
import com.magento.api.CatalogProductImageEntity;
import com.magento.api.CatalogProductImageFileEntity;
import com.magento.api.CatalogProductLinkAttributeEntity;
import com.magento.api.CatalogProductLinkEntity;
import com.magento.api.CatalogProductRequestAttributes;
import com.magento.api.CatalogProductReturnEntity;
import com.magento.api.CatalogProductTierPriceEntity;
import com.magento.api.CatalogProductTypeEntity;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.UnhandledException;
import org.apache.commons.lang.Validate;
import org.mule.module.magento.api.AbstractMagentoClient;
import org.mule.module.magento.api.AxisPortProvider;
import org.mule.module.magento.api.catalog.MagentoCatalogClient;
import org.mule.module.magento.api.catalog.model.MediaMimeType;
import org.mule.module.magento.api.catalog.model.ProductIdentifier;
import org.mule.module.magento.filters.FiltersParser;
import org.mule.util.Base64;

public class AxisMagentoCatalogClient
extends AbstractMagentoClient
implements MagentoCatalogClient<RemoteException> {
    public AxisMagentoCatalogClient(AxisPortProvider provider) {
        super(provider);
    }

    @Override
    public List<CatalogAssignedProduct> listCategoryProducts(int categoryId) throws RemoteException {
        return Arrays.asList(this.getPort().catalogCategoryAssignedProducts(this.getSessionId(), categoryId));
    }

    @Override
    public boolean addCategoryProduct(int categoryId, @NotNull ProductIdentifier productId, String position) throws RemoteException {
        return this.getPort().catalogCategoryAssignProduct(this.getSessionId(), categoryId, productId.getIdentifierAsString(), position, productId.getIdentifierType());
    }

    @Override
    public int createCategory(int parentId, @NotNull CatalogCategoryEntityCreate attributes, String storeView) throws RemoteException {
        Validate.notNull((Object)attributes);
        return this.getPort().catalogCategoryCreate(this.getSessionId(), parentId, attributes, storeView);
    }

    @Override
    public int getCatalogCurrentStoreView() throws RemoteException {
        return this.getPort().catalogCategoryCurrentStore(this.getSessionId(), null);
    }

    @Override
    public int updateCatalogCurrentStoreView(String storeViewIdOrCode) throws RemoteException {
        Validate.notNull((Object)storeViewIdOrCode);
        return this.getPort().catalogCategoryCurrentStore(this.getSessionId(), storeViewIdOrCode);
    }

    @Override
    public boolean deleteCategory(int categoryId) throws RemoteException {
        return this.getPort().catalogCategoryDelete(this.getSessionId(), categoryId);
    }

    @Override
    public CatalogCategoryInfo getCategory(int categoryId, String storeView, List<String> attributeNames) throws RemoteException {
        return this.getPort().catalogCategoryInfo(this.getSessionId(), categoryId, storeView, AxisMagentoCatalogClient.toArray(attributeNames, String.class));
    }

    @Override
    public List<CatalogCategoryEntityNoChildren> listCategoryLevels(String website, String storeView, String parentCategory) throws RemoteException {
        return Arrays.asList(this.getPort().catalogCategoryLevel(this.getSessionId(), website, storeView, parentCategory));
    }

    @Override
    public void moveCategory(int categoryId, int parentId, String afterId) throws RemoteException {
        this.getPort().catalogCategoryMove(this.getSessionId(), categoryId, parentId, afterId);
    }

    @Override
    public boolean deleteCategoryProduct(int categoryId, @NotNull ProductIdentifier productId) throws RemoteException {
        return this.getPort().catalogCategoryRemoveProduct(this.getSessionId(), categoryId, productId.getIdentifierAsString(), productId.getIdentifierType());
    }

    @Override
    public CatalogCategoryTree getCategoryTree(String parentId, String storeView) throws RemoteException {
        return this.getPort().catalogCategoryTree(this.getSessionId(), parentId, storeView);
    }

    @Override
    public boolean updateCategory(int categoryId, @NotNull CatalogCategoryEntityCreate attributes, String storeView) throws RemoteException {
        Validate.notNull((Object)attributes);
        return this.getPort().catalogCategoryUpdate(this.getSessionId(), categoryId, attributes, storeView);
    }

    @Override
    public boolean updateCategoryProduct(int categoryId, @NotNull ProductIdentifier productId, String position) throws RemoteException {
        return this.getPort().catalogCategoryUpdateProduct(this.getSessionId(), categoryId, productId.getIdentifierAsString(), position, productId.getIdentifierType());
    }

    @Override
    public List<CatalogInventoryStockItemEntity> listInventoryStockItems(List<String> products) throws RemoteException {
        return Arrays.asList(this.getPort().catalogInventoryStockItemList(this.getSessionId(), AxisMagentoCatalogClient.toArray(products, String.class)));
    }

    @Override
    public int updateInventoryStockItem(@NotNull ProductIdentifier productId, @NotNull CatalogInventoryStockItemUpdateEntity attributes) throws RemoteException {
        Validate.notNull((Object)attributes);
        return this.getPort().catalogInventoryStockItemUpdate(this.getSessionId(), productId.getIdentifierAsString(), attributes);
    }

    @Override
    public int createProduct(@NotNull String type, @NotNull int set, @NotNull String sku, CatalogProductCreateEntity attributes, List<AssociativeEntity> additionalAttributes, String storeView) throws RemoteException {
        Validate.notNull((Object)type);
        Validate.notNull((Object)set);
        Validate.notNull((Object)sku);
        CatalogProductCreateEntity productData = attributes;
        if (additionalAttributes != null) {
            productData.setAdditional_attributes(new CatalogProductAdditionalAttributesEntity(null, additionalAttributes.toArray(new AssociativeEntity[additionalAttributes.size()])));
        }
        return this.getPort().catalogProductCreate(this.getSessionId(), type, String.valueOf(set), sku, productData, storeView);
    }

    @Override
    public int deleteProduct(ProductIdentifier productId) throws RemoteException {
        return this.getPort().catalogProductDelete(this.getSessionId(), productId.getIdentifierAsString(), productId.getIdentifierType());
    }

    @Override
    public CatalogProductReturnEntity getProductSpecialPrice(@NotNull ProductIdentifier productId, String storeView) throws RemoteException {
        return this.getPort().catalogProductGetSpecialPrice(this.getSessionId(), productId.getIdentifierAsString(), storeView, productId.getIdentifierType());
    }

    @Override
    public CatalogProductReturnEntity getProduct(@NotNull ProductIdentifier productId, String storeView, List<String> attributeNames, List<String> additionalAttributeNames) throws RemoteException {
        Validate.notNull((Object)productId);
        Validate.isTrue((CollectionUtils.isNotEmpty(attributeNames) || CollectionUtils.isNotEmpty(additionalAttributeNames) ? 1 : 0) != 0);
        CatalogProductRequestAttributes request = new CatalogProductRequestAttributes(AxisMagentoCatalogClient.toArray(this.nullToEmpty(attributeNames), String.class), AxisMagentoCatalogClient.toArray(this.nullToEmpty(additionalAttributeNames), String.class));
        return this.getPort().catalogProductInfo(this.getSessionId(), productId.getIdentifierAsString(), storeView, request, productId.getIdentifierType());
    }

    @Override
    public List<CatalogProductEntity> listProducts(String filters, String storeView) throws RemoteException {
        return Arrays.asList(this.getPort().catalogProductList(this.getSessionId(), FiltersParser.parse(filters), storeView));
    }

    @Override
    public int updateProductSpecialPrice(@NotNull ProductIdentifier productId, @NotNull String specialPrice, String fromDate, String toDate, String storeView) throws RemoteException {
        Validate.notNull((Object)specialPrice);
        Validate.notNull((Object)productId);
        return this.getPort().catalogProductSetSpecialPrice(this.getSessionId(), productId.getIdentifierAsString(), specialPrice, fromDate, toDate, storeView, productId.getIdentifierType());
    }

    @Override
    public boolean updateProduct(@NotNull ProductIdentifier productId, CatalogProductCreateEntity attributes, List<AssociativeEntity> additionalAttributes, String storeView) throws RemoteException {
        Validate.notNull((Object)productId);
        Validate.isTrue((attributes != null || additionalAttributes != null ? 1 : 0) != 0);
        CatalogProductCreateEntity productData = attributes;
        if (additionalAttributes != null) {
            productData.setAdditional_attributes(new CatalogProductAdditionalAttributesEntity(null, additionalAttributes.toArray(new AssociativeEntity[additionalAttributes.size()])));
        }
        return this.getPort().catalogProductUpdate(this.getSessionId(), productId.getIdentifierAsString(), productData, storeView, productId.getIdentifierType());
    }

    @Override
    public String createProductAttributeMedia(@NotNull ProductIdentifier productId, CatalogProductAttributeMediaCreateEntity attributes, @NotNull InputStream content, @NotNull MediaMimeType mimeType, @NotNull String baseFileName, String storeView) throws RemoteException {
        Validate.notNull((Object)productId);
        Validate.notNull((Object)((Object)mimeType));
        CatalogProductImageFileEntity file = new CatalogProductImageFileEntity(this.encodeStream(content), mimeType.toString(), baseFileName);
        attributes.setFile(file);
        return this.getPort().catalogProductAttributeMediaCreate(this.getSessionId(), productId.getIdentifierAsString(), attributes, storeView, productId.getIdentifierType());
    }

    private String encodeStream(InputStream content) {
        try {
            String string = Base64.encodeBytes((byte[])IOUtils.toByteArray((InputStream)content));
            return string;
        }
        catch (IOException e) {
            throw new UnhandledException("Could not encode the stream", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)content);
        }
    }

    @Override
    public CatalogProductImageEntity getProductAttributeMedia(@NotNull ProductIdentifier productId, @NotNull String file, String storeView) throws RemoteException {
        return this.getPort().catalogProductAttributeMediaInfo(this.getSessionId(), productId.getIdentifierAsString(), file, storeView, productId.getIdentifierType());
    }

    @Override
    public List<CatalogProductImageEntity> listProductAttributeMedia(@NotNull ProductIdentifier productId, String storeViewIdOrCode) throws RemoteException {
        return Arrays.asList(this.getPort().catalogProductAttributeMediaList(this.getSessionId(), productId.getIdentifierAsString(), storeViewIdOrCode, productId.getIdentifierType()));
    }

    @Override
    public boolean deleteProductAttributeMedia(@NotNull ProductIdentifier productId, @NotNull String file) throws RemoteException {
        Validate.notNull((Object)productId);
        Validate.notNull((Object)file);
        return this.getPort().catalogProductAttributeMediaRemove(this.getSessionId(), productId.getIdentifierAsString(), file, productId.getIdentifierType());
    }

    @Override
    public List<CatalogProductAttributeMediaTypeEntity> listProductAttributeMediaTypes(int setId) throws RemoteException {
        return Arrays.asList(this.getPort().catalogProductAttributeMediaTypes(this.getSessionId(), String.valueOf(setId)));
    }

    @Override
    public boolean updateProductAttributeMedia(@NotNull ProductIdentifier productId, String fileName, @NotNull CatalogProductAttributeMediaCreateEntity attributes, String storeView) throws RemoteException {
        Validate.notNull((Object)attributes);
        return this.getPort().catalogProductAttributeMediaUpdate(this.getSessionId(), productId.getIdentifierAsString(), fileName, attributes, storeView, productId.getIdentifierType());
    }

    @Override
    public List<CatalogAttributeEntity> listCategoryAttributes() throws RemoteException {
        return Arrays.asList(this.getPort().catalogCategoryAttributeList(this.getSessionId()));
    }

    @Override
    public List<CatalogAttributeOptionEntity> listCategoryAttributeOptions(@NotNull String attributeId, String storeView) throws RemoteException {
        Validate.notNull((Object)attributeId);
        return Arrays.asList(this.getPort().catalogCategoryAttributeOptions(this.getSessionId(), attributeId, storeView));
    }

    @Override
    public List<CatalogAttributeEntity> listProductAttributes(int setId) throws RemoteException {
        return Arrays.asList(this.getPort().catalogProductAttributeList(this.getSessionId(), setId));
    }

    @Override
    @NotNull
    public List<CatalogAttributeOptionEntity> listProductAttributeOptions(@NotNull String attributeId, String storeView) throws RemoteException {
        Validate.notNull((Object)attributeId);
        return Arrays.asList(this.getPort().catalogProductAttributeOptions(this.getSessionId(), attributeId, storeView));
    }

    @Override
    @NotNull
    public List<CatalogProductAttributeSetEntity> listProductAttributeSets() throws RemoteException {
        return Arrays.asList(this.getPort().catalogProductAttributeSetList(this.getSessionId()));
    }

    @Override
    @NotNull
    public List<CatalogProductTypeEntity> listProductTypes() throws RemoteException {
        return Arrays.asList(this.getPort().catalogProductTypeList(this.getSessionId()));
    }

    @Override
    @NotNull
    public List<CatalogProductTierPriceEntity> listProductAttributeTierPrices(@NotNull ProductIdentifier productId) throws RemoteException {
        Validate.notNull((Object)productId);
        return Arrays.asList(this.getPort().catalogProductAttributeTierPriceInfo(this.getSessionId(), productId.getIdentifierAsString(), productId.getIdentifierType()));
    }

    @Override
    public int updateProductAttributeTierPrice(@NotNull ProductIdentifier productId, @NotNull CatalogProductTierPriceEntity attributes) throws RemoteException {
        Validate.notNull((Object)productId);
        Validate.notNull((Object)attributes);
        return this.getPort().catalogProductAttributeTierPriceUpdate(this.getSessionId(), productId.getIdentifierAsString(), new CatalogProductTierPriceEntity[]{attributes}, productId.getIdentifierType());
    }

    @Override
    public boolean addProductLink(@NotNull String type, @NotNull ProductIdentifier productId, @NotNull String linkedProductIdOrSku, CatalogProductLinkEntity attributes) throws RemoteException {
        Validate.notNull((Object)type);
        Validate.notNull((Object)productId);
        Validate.notNull((Object)linkedProductIdOrSku);
        return this.getPort().catalogProductLinkAssign(this.getSessionId(), type, productId.getIdentifierAsString(), linkedProductIdOrSku, attributes, productId.getIdentifierType());
    }

    @Override
    public List<CatalogProductLinkAttributeEntity> listProductLinkAttributes(String type) throws RemoteException {
        return Arrays.asList(this.getPort().catalogProductLinkAttributes(this.getSessionId(), type));
    }

    @Override
    public List<CatalogProductLinkEntity> listProductLink(@NotNull String type, @NotNull ProductIdentifier productId) throws RemoteException {
        return Arrays.asList(this.getPort().catalogProductLinkList(this.getSessionId(), type, productId.getIdentifierAsString(), productId.getIdentifierType()));
    }

    @Override
    public boolean deleteProductLink(@NotNull String type, @NotNull ProductIdentifier productId, @NotNull String linkedProductIdOrSku) throws RemoteException {
        return this.getPort().catalogProductLinkRemove(this.getSessionId(), type, productId.getIdentifierAsString(), linkedProductIdOrSku, productId.getIdentifierType());
    }

    @Override
    public List<String> listProductLinkTypes() throws RemoteException {
        return Arrays.asList(this.getPort().catalogProductLinkTypes(this.getSessionId()));
    }

    @Override
    public boolean updateProductLink(@NotNull String type, @NotNull ProductIdentifier productId, @NotNull String linkedProduct, @NotNull CatalogProductLinkEntity attributes) throws RemoteException {
        Validate.notNull((Object)attributes);
        Validate.notNull((Object)type);
        Validate.notNull((Object)linkedProduct);
        return this.getPort().catalogProductLinkUpdate(this.getSessionId(), type, productId.getIdentifierAsString(), linkedProduct, attributes, productId.getIdentifierType());
    }
}

