/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.magento.api;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.axis.AxisFault;
import org.apache.commons.lang.Validate;
import org.mule.module.magento.MagentoCloudConnector;
import org.mule.module.magento.api.MagentoException;
import org.mule.util.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MagentoClientAdaptor {
    private static Logger log = LoggerFactory.getLogger(MagentoCloudConnector.class);

    private MagentoClientAdaptor() {
    }

    public static <T> T adapt(Class<T> receptorClass, final T receptor) {
        Validate.isTrue((boolean)receptorClass.isInterface());
        return (T)Proxy.newProxyInstance(MagentoClientAdaptor.class.getClassLoader(), new Class[]{receptorClass}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Entering {} with args {}", (Object)method.getName(), (Object)args);
                    }
                    Object ret = method.invoke(receptor, args);
                    if (log.isDebugEnabled()) {
                        log.debug("Returning from {} with value {}", (Object)method.getName(), ret);
                    }
                    return ret;
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() instanceof AxisFault) {
                        if (log.isWarnEnabled()) {
                            log.warn("An exception was thrown while invoking {}: {}", (Object)method.getName(), (Object)e.getCause());
                        }
                        throw MagentoClientAdaptor.toMagentoException((AxisFault)e.getCause());
                    }
                    throw e;
                }
            }
        });
    }

    private static MagentoException toMagentoException(AxisFault fault) {
        String faultCode = fault.getFaultCode().toString();
        if (NumberUtils.isNumber((String)faultCode)) {
            return new MagentoException(Integer.parseInt(faultCode), fault.getFaultString(), fault);
        }
        return new MagentoException(-1, fault.getFaultString(), fault);
    }

    public static class Holder {
        private final Object value;

        public Holder(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

