/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.magento;

import com.magento.api.ApiEntity;
import com.magento.api.ApiMethodEntity;
import com.magento.api.AssociativeEntity;
import com.magento.api.AssociativeMultiEntity;
import com.magento.api.CatalogAssignedProduct;
import com.magento.api.CatalogAttributeEntity;
import com.magento.api.CatalogAttributeOptionEntity;
import com.magento.api.CatalogCategoryEntity;
import com.magento.api.CatalogCategoryEntityCreate;
import com.magento.api.CatalogCategoryEntityNoChildren;
import com.magento.api.CatalogCategoryInfo;
import com.magento.api.CatalogCategoryTree;
import com.magento.api.CatalogInventoryStockItemEntity;
import com.magento.api.CatalogInventoryStockItemUpdateEntity;
import com.magento.api.CatalogProductAdditionalAttributesEntity;
import com.magento.api.CatalogProductAttributeEntity;
import com.magento.api.CatalogProductAttributeFrontendLabelEntity;
import com.magento.api.CatalogProductAttributeMediaCreateEntity;
import com.magento.api.CatalogProductAttributeMediaTypeEntity;
import com.magento.api.CatalogProductAttributeOptionLabelEntity;
import com.magento.api.CatalogProductAttributeSetEntity;
import com.magento.api.CatalogProductCreateEntity;
import com.magento.api.CatalogProductCustomOptionAdditionalFieldsEntity;
import com.magento.api.CatalogProductCustomOptionInfoEntity;
import com.magento.api.CatalogProductCustomOptionListEntity;
import com.magento.api.CatalogProductCustomOptionTypesEntity;
import com.magento.api.CatalogProductCustomOptionValueAddEntity;
import com.magento.api.CatalogProductCustomOptionValueInfoEntity;
import com.magento.api.CatalogProductCustomOptionValueListEntity;
import com.magento.api.CatalogProductCustomOptionValueUpdateEntity;
import com.magento.api.CatalogProductDownloadableLinkAddEntity;
import com.magento.api.CatalogProductDownloadableLinkAddSampleEntity;
import com.magento.api.CatalogProductDownloadableLinkEntity;
import com.magento.api.CatalogProductDownloadableLinkFileEntity;
import com.magento.api.CatalogProductDownloadableLinkFileInfoEntity;
import com.magento.api.CatalogProductDownloadableLinkInfoEntity;
import com.magento.api.CatalogProductDownloadableLinkSampleEntity;
import com.magento.api.CatalogProductEntity;
import com.magento.api.CatalogProductImageEntity;
import com.magento.api.CatalogProductImageFileEntity;
import com.magento.api.CatalogProductLinkAttributeEntity;
import com.magento.api.CatalogProductLinkEntity;
import com.magento.api.CatalogProductReturnEntity;
import com.magento.api.CatalogProductTagAddEntity;
import com.magento.api.CatalogProductTagInfoEntity;
import com.magento.api.CatalogProductTagListEntity;
import com.magento.api.CatalogProductTagUpdateEntity;
import com.magento.api.CatalogProductTierPriceEntity;
import com.magento.api.CatalogProductTypeEntity;
import com.magento.api.CustomerAddressEntityCreate;
import com.magento.api.CustomerAddressEntityItem;
import com.magento.api.CustomerCustomerEntity;
import com.magento.api.CustomerCustomerEntityToCreate;
import com.magento.api.CustomerGroupEntity;
import com.magento.api.DirectoryCountryEntity;
import com.magento.api.DirectoryRegionEntity;
import com.magento.api.ExistsFaltureEntity;
import com.magento.api.GiftMessageAssociativeProductsEntity;
import com.magento.api.MagentoInfoEntity;
import com.magento.api.OrderItemIdQty;
import com.magento.api.SalesOrderAddressEntity;
import com.magento.api.SalesOrderCreditmemoCommentEntity;
import com.magento.api.SalesOrderCreditmemoEntity;
import com.magento.api.SalesOrderCreditmemoItemEntity;
import com.magento.api.SalesOrderEntity;
import com.magento.api.SalesOrderInvoiceCommentEntity;
import com.magento.api.SalesOrderInvoiceEntity;
import com.magento.api.SalesOrderInvoiceItemEntity;
import com.magento.api.SalesOrderItemEntity;
import com.magento.api.SalesOrderListEntity;
import com.magento.api.SalesOrderPaymentEntity;
import com.magento.api.SalesOrderShipmentCommentEntity;
import com.magento.api.SalesOrderShipmentEntity;
import com.magento.api.SalesOrderShipmentItemEntity;
import com.magento.api.SalesOrderShipmentTrackEntity;
import com.magento.api.SalesOrderStatusHistoryEntity;
import com.magento.api.ShoppingCartAddressEntity;
import com.magento.api.ShoppingCartCustomerAddressEntity;
import com.magento.api.ShoppingCartCustomerEntity;
import com.magento.api.ShoppingCartInfoEntity;
import com.magento.api.ShoppingCartItemEntity;
import com.magento.api.ShoppingCartLicenseEntity;
import com.magento.api.ShoppingCartPaymentEntity;
import com.magento.api.ShoppingCartPaymentMethodEntity;
import com.magento.api.ShoppingCartPaymentMethodResponseEntityArray;
import com.magento.api.ShoppingCartProductEntity;
import com.magento.api.ShoppingCartShippingMethodEntity;
import com.magento.api.ShoppingCartTotalsEntity;
import com.magento.api.StoreEntity;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.mule.api.annotations.param.Payload;
import org.mule.common.metadata.DefaultMetaData;
import org.mule.common.metadata.DefaultMetaDataKey;
import org.mule.common.metadata.DefaultPojoMetaDataModel;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.query.Query;
import org.mule.common.query.QueryVisitor;
import org.mule.module.magento.api.AxisPortProvider;
import org.mule.module.magento.api.DefaultAxisPortProvider;
import org.mule.module.magento.api.MagentoClientAdaptor;
import org.mule.module.magento.api.MagentoException;
import org.mule.module.magento.api.catalog.AxisMagentoCatalogClient;
import org.mule.module.magento.api.catalog.MagentoCatalogClient;
import org.mule.module.magento.api.catalog.model.MediaMimeType;
import org.mule.module.magento.api.catalog.model.ProductIdentifiers;
import org.mule.module.magento.api.customer.AxisMagentoInventoryClient;
import org.mule.module.magento.api.customer.MagentoInventoryClient;
import org.mule.module.magento.api.directory.AxisMagentoDirectoryClient;
import org.mule.module.magento.api.directory.MagentoDirectoryClient;
import org.mule.module.magento.api.inventory.AxisMagentoCustomerClient;
import org.mule.module.magento.api.inventory.MagentoCustomerClient;
import org.mule.module.magento.api.order.AxisMagentoOrderClient;
import org.mule.module.magento.api.order.MagentoOrderClient;
import org.mule.module.magento.api.order.model.Carrier;
import org.mule.module.magento.api.shoppingCart.AxisMagentoShoppingCartClient;
import org.mule.module.magento.api.shoppingCart.MagentoShoppingCartClient;
import org.mule.module.magento.query.MagentoQueryVisitor;

public class MagentoCloudConnector {
    private static final String ENTITY_PACKAGE = "com.magento.api";
    private MagentoOrderClient<MagentoException> orderClient;
    private MagentoCustomerClient<MagentoException> customerClient;
    private MagentoInventoryClient<MagentoException> inventoryClient;
    private MagentoDirectoryClient<MagentoException> directoryClient;
    private MagentoCatalogClient<MagentoException> catalogClient;
    private MagentoShoppingCartClient<MagentoException> shoppingCartClient;
    private String user;
    private String serverAddress;

    public void initialiseConnector(String username, String password, String address) throws ConnectionException {
        this.setUser(username);
        this.setServerAddress(address);
        PortProviderInitializer initializer = new PortProviderInitializer(username, password, address);
        this.setOrderClient(new AxisMagentoOrderClient(initializer.getPortProvider()));
        this.setCustomerClient(new AxisMagentoCustomerClient(initializer.getPortProvider()));
        this.setInventoryClient(new AxisMagentoInventoryClient(initializer.getPortProvider()));
        this.setDirectoryClient(new AxisMagentoDirectoryClient(initializer.getPortProvider()));
        this.setCatalogClient(new AxisMagentoCatalogClient(initializer.getPortProvider()));
        this.setShoppingCartClient(new AxisMagentoShoppingCartClient(initializer.getPortProvider()));
        try {
            this.getCatalogCurrentStoreView();
        }
        catch (Exception e) {
            ConnectionException connectionException = new ConnectionException(ConnectionExceptionCode.INCORRECT_CREDENTIALS, null, e.getMessage());
            connectionException.initCause((Throwable)e);
            throw connectionException;
        }
    }

    public boolean validateConnection() {
        return this.orderClient != null && this.customerClient != null && this.inventoryClient != null && this.directoryClient != null && this.catalogClient != null && this.shoppingCartClient != null;
    }

    public void disconnect() {
        this.setOrderClient(null);
        this.setCustomerClient(null);
        this.setInventoryClient(null);
        this.setDirectoryClient(null);
        this.setCatalogClient(null);
        this.setShoppingCartClient(null);
    }

    public String connectionId() {
        return String.format("%s-at-%s", this.getUser(), this.getServerAddress());
    }

    private MetaDataKey createKey(Class<?> cls) {
        return new DefaultMetaDataKey(cls.getSimpleName(), cls.getSimpleName());
    }

    public List<MetaDataKey> getMetadataKeys() {
        ArrayList<MetaDataKey> keys = new ArrayList<MetaDataKey>();
        keys.add(this.createKey(ApiEntity.class));
        keys.add(this.createKey(ApiMethodEntity.class));
        keys.add(this.createKey(AssociativeEntity.class));
        keys.add(this.createKey(AssociativeMultiEntity.class));
        keys.add(this.createKey(CatalogAttributeEntity.class));
        keys.add(this.createKey(CatalogAttributeOptionEntity.class));
        keys.add(this.createKey(CatalogCategoryEntity.class));
        keys.add(this.createKey(CatalogInventoryStockItemEntity.class));
        keys.add(this.createKey(CatalogInventoryStockItemUpdateEntity.class));
        keys.add(this.createKey(CatalogProductAdditionalAttributesEntity.class));
        keys.add(this.createKey(CatalogProductAttributeEntity.class));
        keys.add(this.createKey(CatalogProductAttributeFrontendLabelEntity.class));
        keys.add(this.createKey(CatalogProductAttributeMediaCreateEntity.class));
        keys.add(this.createKey(CatalogProductAttributeMediaTypeEntity.class));
        keys.add(this.createKey(CatalogProductAttributeOptionLabelEntity.class));
        keys.add(this.createKey(CatalogProductAttributeSetEntity.class));
        keys.add(this.createKey(CatalogProductCreateEntity.class));
        keys.add(this.createKey(CatalogProductCustomOptionAdditionalFieldsEntity.class));
        keys.add(this.createKey(CatalogProductCustomOptionInfoEntity.class));
        keys.add(this.createKey(CatalogProductCustomOptionListEntity.class));
        keys.add(this.createKey(CatalogProductCustomOptionTypesEntity.class));
        keys.add(this.createKey(CatalogProductCustomOptionValueAddEntity.class));
        keys.add(this.createKey(CatalogProductCustomOptionValueInfoEntity.class));
        keys.add(this.createKey(CatalogProductCustomOptionValueListEntity.class));
        keys.add(this.createKey(CatalogProductCustomOptionValueUpdateEntity.class));
        keys.add(this.createKey(CatalogProductDownloadableLinkAddEntity.class));
        keys.add(this.createKey(CatalogProductDownloadableLinkAddSampleEntity.class));
        keys.add(this.createKey(CatalogProductDownloadableLinkEntity.class));
        keys.add(this.createKey(CatalogProductDownloadableLinkFileEntity.class));
        keys.add(this.createKey(CatalogProductDownloadableLinkFileInfoEntity.class));
        keys.add(this.createKey(CatalogProductDownloadableLinkInfoEntity.class));
        keys.add(this.createKey(CatalogProductDownloadableLinkSampleEntity.class));
        keys.add(this.createKey(CatalogProductEntity.class));
        keys.add(this.createKey(CatalogProductImageEntity.class));
        keys.add(this.createKey(CatalogProductImageFileEntity.class));
        keys.add(this.createKey(CatalogProductLinkAttributeEntity.class));
        keys.add(this.createKey(CatalogProductLinkEntity.class));
        keys.add(this.createKey(CatalogProductReturnEntity.class));
        keys.add(this.createKey(CatalogProductTagAddEntity.class));
        keys.add(this.createKey(CatalogProductTagInfoEntity.class));
        keys.add(this.createKey(CatalogProductTagListEntity.class));
        keys.add(this.createKey(CatalogProductTagUpdateEntity.class));
        keys.add(this.createKey(CatalogProductTierPriceEntity.class));
        keys.add(this.createKey(CatalogProductTypeEntity.class));
        keys.add(this.createKey(CustomerCustomerEntity.class));
        keys.add(this.createKey(CustomerGroupEntity.class));
        keys.add(this.createKey(DirectoryCountryEntity.class));
        keys.add(this.createKey(DirectoryRegionEntity.class));
        keys.add(this.createKey(ExistsFaltureEntity.class));
        keys.add(this.createKey(GiftMessageAssociativeProductsEntity.class));
        keys.add(this.createKey(MagentoInfoEntity.class));
        keys.add(this.createKey(SalesOrderAddressEntity.class));
        keys.add(this.createKey(SalesOrderCreditmemoCommentEntity.class));
        keys.add(this.createKey(SalesOrderCreditmemoEntity.class));
        keys.add(this.createKey(SalesOrderCreditmemoItemEntity.class));
        keys.add(this.createKey(SalesOrderEntity.class));
        keys.add(this.createKey(SalesOrderInvoiceCommentEntity.class));
        keys.add(this.createKey(SalesOrderInvoiceEntity.class));
        keys.add(this.createKey(SalesOrderInvoiceItemEntity.class));
        keys.add(this.createKey(SalesOrderItemEntity.class));
        keys.add(this.createKey(SalesOrderListEntity.class));
        keys.add(this.createKey(SalesOrderPaymentEntity.class));
        keys.add(this.createKey(SalesOrderShipmentCommentEntity.class));
        keys.add(this.createKey(SalesOrderShipmentEntity.class));
        keys.add(this.createKey(SalesOrderShipmentItemEntity.class));
        keys.add(this.createKey(SalesOrderShipmentTrackEntity.class));
        keys.add(this.createKey(SalesOrderStatusHistoryEntity.class));
        keys.add(this.createKey(ShoppingCartAddressEntity.class));
        keys.add(this.createKey(ShoppingCartCustomerAddressEntity.class));
        keys.add(this.createKey(ShoppingCartCustomerEntity.class));
        keys.add(this.createKey(ShoppingCartInfoEntity.class));
        keys.add(this.createKey(ShoppingCartItemEntity.class));
        keys.add(this.createKey(ShoppingCartLicenseEntity.class));
        keys.add(this.createKey(ShoppingCartPaymentEntity.class));
        keys.add(this.createKey(ShoppingCartPaymentMethodEntity.class));
        keys.add(this.createKey(ShoppingCartProductEntity.class));
        keys.add(this.createKey(ShoppingCartShippingMethodEntity.class));
        keys.add(this.createKey(ShoppingCartTotalsEntity.class));
        keys.add(this.createKey(StoreEntity.class));
        return keys;
    }

    public MetaData getMetadata(MetaDataKey key) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(String.format("%s.%s", ENTITY_PACKAGE, key.getId()));
        return new DefaultMetaData((MetaDataModel)new DefaultPojoMetaDataModel(clazz));
    }

    public boolean addOrderShipmentComment(String shipmentId, String comment, boolean sendEmail, boolean includeCommentInEmail) {
        return this.orderClient.addOrderShipmentComment(shipmentId, comment, sendEmail, includeCommentInEmail);
    }

    public int addOrderShipmentTrack(String shipmentId, String carrierCode, String title, String trackId) {
        return this.orderClient.addOrderShipmentTrack(shipmentId, carrierCode, title, trackId);
    }

    public boolean cancelOrder(String orderId) {
        return this.orderClient.cancelOrder(orderId);
    }

    public String createOrderShipment(String orderId, List<OrderItemIdQty> itemsQuantities, String comment, boolean sendEmail, boolean includeCommentInEmail) {
        return this.orderClient.createOrderShipment(orderId, itemsQuantities, comment, sendEmail, includeCommentInEmail);
    }

    public SalesOrderEntity getOrder(String orderId) {
        return this.orderClient.getOrder(orderId);
    }

    public SalesOrderInvoiceEntity getOrderInvoice(String invoiceId) {
        return this.orderClient.getOrderInvoice(invoiceId);
    }

    public List<Carrier> getOrderShipmentCarriers(String orderId) {
        return this.orderClient.getOrderShipmentCarriers(orderId);
    }

    public SalesOrderShipmentEntity getOrderShipment(String shipmentId) {
        return this.orderClient.getOrderShipment(shipmentId);
    }

    public boolean holdOrder(String orderId) {
        return this.orderClient.holdOrder(orderId);
    }

    public List<SalesOrderListEntity> listOrders(String filter) {
        return this.orderClient.listOrders(filter);
    }

    public String toNativeQuery(Query query) {
        MagentoQueryVisitor visitor = new MagentoQueryVisitor();
        query.getFilterExpression().accept((QueryVisitor)visitor);
        return visitor.toQuery();
    }

    public List<SalesOrderInvoiceEntity> listOrdersInvoices(String filter) {
        return this.orderClient.listOrdersInvoices(filter);
    }

    public List<SalesOrderShipmentEntity> listOrdersShipments(String filter) {
        return this.orderClient.listOrdersShipments(filter);
    }

    public boolean deleteOrderShipmentTrack(String shipmentId, String trackId) {
        return this.orderClient.deleteOrderShipmentTrack(shipmentId, trackId);
    }

    public boolean addOrderComment(String orderId, String status, String comment, boolean sendEmail) {
        return this.orderClient.addOrderComment(orderId, status, comment, sendEmail);
    }

    public boolean unholdOrder(String orderId) {
        return this.orderClient.unholdOrder(orderId);
    }

    public String createOrderInvoice(String orderId, List<OrderItemIdQty> itemsQuantities, String comment, boolean sendEmail, boolean includeCommentInEmail) {
        return this.orderClient.createOrderInvoice(orderId, itemsQuantities, comment, sendEmail, includeCommentInEmail);
    }

    public boolean addOrderInvoiceComment(String invoiceId, String comment, boolean sendEmail, boolean includeCommentInEmail) {
        return this.orderClient.addOrderInvoiceComment(invoiceId, comment, sendEmail, includeCommentInEmail);
    }

    public void captureOrderInvoice(String invoiceId) {
        this.orderClient.captureOrderInvoice(invoiceId);
    }

    public boolean voidOrderInvoice(String invoiceId) {
        return this.orderClient.voidOrderInvoice(invoiceId);
    }

    public void cancelOrderInvoice(String invoiceId) {
        this.orderClient.cancelOrderInvoice(invoiceId);
    }

    public int createCustomerAddress(int customerId, CustomerAddressEntityCreate customerAddress) {
        return this.customerClient.createCustomerAddress(customerId, customerAddress);
    }

    public int createCustomer(CustomerCustomerEntityToCreate customer) {
        return this.customerClient.createCustomer(customer);
    }

    public boolean deleteCustomer(int customerId) {
        return this.customerClient.deleteCustomer(customerId);
    }

    public boolean deleteCustomerAddress(int addressId) {
        return this.customerClient.deleteCustomerAddress(addressId);
    }

    public CustomerCustomerEntity getCustomer(int customerId, List<String> attributeNames) {
        return this.customerClient.getCustomer(customerId, attributeNames);
    }

    public CustomerAddressEntityItem getCustomerAddress(int addressId) {
        return this.customerClient.getCustomerAddress(addressId);
    }

    public List<CustomerAddressEntityItem> listCustomerAddresses(int customerId) {
        return this.customerClient.listCustomerAddresses(customerId);
    }

    public List<CustomerGroupEntity> listCustomerGroups() {
        return this.customerClient.listCustomerGroups();
    }

    public List<CustomerCustomerEntity> listCustomers(String filter) {
        return this.customerClient.listCustomers(filter);
    }

    public boolean updateCustomer(int customerId, CustomerCustomerEntityToCreate customer) {
        return this.customerClient.updateCustomer(customerId, customer);
    }

    public boolean updateCustomerAddress(int addressId, CustomerAddressEntityCreate customerAddress) {
        return this.customerClient.updateCustomerAddress(addressId, customerAddress);
    }

    public List<CatalogInventoryStockItemEntity> listStockItems(List<String> productIdOrSkus) {
        return this.inventoryClient.listStockItems(productIdOrSkus);
    }

    public int updateStockItem(String productIdOrSku, CatalogInventoryStockItemUpdateEntity stockItem) {
        return this.inventoryClient.updateStockItem(productIdOrSku, stockItem);
    }

    public List<DirectoryCountryEntity> listDirectoryCountries() {
        return this.directoryClient.listDirectoryCountries();
    }

    public List<DirectoryRegionEntity> listDirectoryRegions(String countryId) {
        return this.directoryClient.listDirectoryRegions(countryId);
    }

    public boolean addProductLink(String type, Integer productId, String productSku, String productIdOrSku, String linkedProductIdOrSku, CatalogProductLinkEntity productLinkEntity) {
        return this.catalogClient.addProductLink(type, ProductIdentifiers.from(productSku, productId, productIdOrSku), linkedProductIdOrSku, productLinkEntity);
    }

    public String createProductAttributeMedia(Integer productId, String productSku, String productIdOrSku, CatalogProductAttributeMediaCreateEntity catalogProductAttributeMediaEntity, String storeViewIdOrCode, @Payload Object payload, MediaMimeType mimeType, String baseFileName) throws FileNotFoundException {
        return this.catalogClient.createProductAttributeMedia(ProductIdentifiers.from(productSku, productId, productIdOrSku), catalogProductAttributeMediaEntity, this.createContent(payload), mimeType, baseFileName, storeViewIdOrCode);
    }

    private InputStream createContent(Object content) throws FileNotFoundException {
        if (content instanceof InputStream) {
            return (InputStream)content;
        }
        if (content instanceof File) {
            return new FileInputStream((File)content);
        }
        if (content instanceof byte[]) {
            return new ByteArrayInputStream((byte[])content);
        }
        throw new IllegalArgumentException("Unsupported Content Type " + content);
    }

    public boolean deleteProductAttributeMedia(Integer productId, String productSku, String productIdOrSku, String fileName) {
        return this.catalogClient.deleteProductAttributeMedia(ProductIdentifiers.from(productSku, productId, productIdOrSku), fileName);
    }

    public boolean deleteProductLink(String type, Integer productId, String productSku, String productIdOrSku, String linkedProductIdOrSku) {
        return this.catalogClient.deleteProductLink(type, ProductIdentifiers.from(productSku, productId, productIdOrSku), linkedProductIdOrSku);
    }

    public CatalogProductImageEntity getProductAttributeMedia(Integer productId, String productSku, String productIdOrSku, String fileName, String storeViewIdOrCode) {
        return this.catalogClient.getProductAttributeMedia(ProductIdentifiers.from(productSku, productId, productIdOrSku), fileName, storeViewIdOrCode);
    }

    public int getCatalogCurrentStoreView() {
        return this.catalogClient.getCatalogCurrentStoreView();
    }

    public int updateCategoryAttributeStoreView(String storeViewIdOrCode) {
        return this.catalogClient.updateCatalogCurrentStoreView(storeViewIdOrCode);
    }

    public List<CatalogAttributeEntity> listCategoryAttributes() {
        return this.catalogClient.listCategoryAttributes();
    }

    public List<CatalogAttributeOptionEntity> listCategoryAttributeOptions(String attributeId, String storeViewIdOrCode) {
        return this.catalogClient.listCategoryAttributeOptions(attributeId, storeViewIdOrCode);
    }

    public List<CatalogProductImageEntity> listProductAttributeMedia(Integer productId, String productSku, String productIdOrSku, String storeViewIdOrCode) {
        return this.catalogClient.listProductAttributeMedia(ProductIdentifiers.from(productSku, productId, productIdOrSku), storeViewIdOrCode);
    }

    public List<CatalogProductAttributeMediaTypeEntity> listProductAttributeMediaTypes(int setId) {
        return this.catalogClient.listProductAttributeMediaTypes(setId);
    }

    public List<CatalogAttributeOptionEntity> listProductAttributeOptions(String attributeId, String storeViewIdOrCode) {
        return this.catalogClient.listProductAttributeOptions(attributeId, storeViewIdOrCode);
    }

    public List<CatalogAttributeEntity> listProductAttributes(int setId) {
        return this.catalogClient.listProductAttributes(setId);
    }

    public List<CatalogProductAttributeSetEntity> listProductAttributeSets() {
        return this.catalogClient.listProductAttributeSets();
    }

    public List<CatalogProductTierPriceEntity> listProductAttributeTierPrices(Integer productId, String productSku, String productIdOrSku) {
        return this.catalogClient.listProductAttributeTierPrices(ProductIdentifiers.from(productSku, productId, productIdOrSku));
    }

    public List<CatalogProductLinkEntity> listProductLink(String type, Integer productId, String productSku, String productIdOrSku) {
        return this.catalogClient.listProductLink(type, ProductIdentifiers.from(productSku, productId, productIdOrSku));
    }

    public List<CatalogProductLinkAttributeEntity> listProductLinkAttributes(String type) {
        return this.catalogClient.listProductLinkAttributes(type);
    }

    public List<String> listProductLinkTypes() {
        return this.catalogClient.listProductLinkTypes();
    }

    public List<CatalogProductTypeEntity> listProductTypes() {
        return this.catalogClient.listProductTypes();
    }

    public boolean updateProductAttributeMedia(Integer productId, String productSku, String productIdOrSku, String fileName, CatalogProductAttributeMediaCreateEntity catalogProductAttributeMediaEntity, String storeViewIdOrCode) {
        return this.catalogClient.updateProductAttributeMedia(ProductIdentifiers.from(productSku, productId, productIdOrSku), fileName, catalogProductAttributeMediaEntity, storeViewIdOrCode);
    }

    public int updateProductAttributeTierPrice(Integer productId, String productSku, String productIdOrSku, CatalogProductTierPriceEntity catalogProductTierPriceEntity) {
        return this.catalogClient.updateProductAttributeTierPrice(ProductIdentifiers.from(productSku, productId, productIdOrSku), catalogProductTierPriceEntity);
    }

    public boolean updateProductLink(String type, Integer productId, String productSku, String productIdOrSku, String linkedProductIdOrSku, CatalogProductLinkEntity catalogProductLinkEntity) {
        return this.catalogClient.updateProductLink(type, ProductIdentifiers.from(productSku, productId, productIdOrSku), linkedProductIdOrSku, catalogProductLinkEntity);
    }

    public List<CatalogAssignedProduct> listCategoryProducts(int categoryId) {
        return this.catalogClient.listCategoryProducts(categoryId);
    }

    public boolean addCategoryProduct(int categoryId, Integer productId, String productSku, String productIdOrSku, String position) {
        return this.catalogClient.addCategoryProduct(categoryId, ProductIdentifiers.from(productSku, productId, productIdOrSku), position);
    }

    public int createCategory(int parentId, CatalogCategoryEntityCreate catalogCategoryEntity, String storeViewIdOrCode) {
        return this.catalogClient.createCategory(parentId, catalogCategoryEntity, storeViewIdOrCode);
    }

    public boolean deleteCategory(int categoryId) {
        return this.catalogClient.deleteCategory(categoryId);
    }

    public CatalogCategoryInfo getCategory(int categoryId, String storeViewIdOrCode, List<String> attributeNames) {
        return this.catalogClient.getCategory(categoryId, storeViewIdOrCode, attributeNames);
    }

    public List<CatalogCategoryEntityNoChildren> listCategoryLevels(String website, String storeViewIdOrCode, String parentCategoryId) {
        return this.catalogClient.listCategoryLevels(website, storeViewIdOrCode, parentCategoryId);
    }

    public void moveCategory(int categoryId, int parentId, String afterId) {
        this.catalogClient.moveCategory(categoryId, parentId, afterId);
    }

    public boolean deleteCategoryProduct(int categoryId, Integer productId, String productSku, String productIdOrSku) {
        return this.catalogClient.deleteCategoryProduct(categoryId, ProductIdentifiers.from(productSku, productId, productIdOrSku));
    }

    public CatalogCategoryTree getCategoryTree(String parentId, String storeViewIdOrCode) {
        return this.catalogClient.getCategoryTree(parentId, storeViewIdOrCode);
    }

    public boolean updateCategory(int categoryId, CatalogCategoryEntityCreate catalogCategoryEntity, String storeViewIdOrCode) {
        return this.catalogClient.updateCategory(categoryId, catalogCategoryEntity, storeViewIdOrCode);
    }

    public boolean updateCategoryProduct(int categoryId, Integer productId, String productSku, String productIdOrSku, String position) {
        return this.catalogClient.updateCategoryProduct(categoryId, ProductIdentifiers.from(productSku, productId, productIdOrSku), position);
    }

    public List<CatalogInventoryStockItemEntity> listInventoryStockItems(List<String> productIdOrSkus) {
        return this.catalogClient.listInventoryStockItems(productIdOrSkus);
    }

    public int updateInventoryStockItem(Integer productId, String productSku, String productIdOrSku, CatalogInventoryStockItemUpdateEntity catalogInventoryStockItem) {
        return this.catalogClient.updateInventoryStockItem(ProductIdentifiers.from(productSku, productId, productIdOrSku), catalogInventoryStockItem);
    }

    public int createProduct(String type, int set, String sku, CatalogProductCreateEntity attributes, List<AssociativeEntity> additionalAttributes, String storeViewIdOrCode) {
        return this.catalogClient.createProduct(type, set, sku, attributes, additionalAttributes, storeViewIdOrCode);
    }

    public int deleteProduct(Integer productId, String productSku, String productIdOrSku) {
        return this.catalogClient.deleteProduct(ProductIdentifiers.from(productSku, productId, productIdOrSku));
    }

    public CatalogProductReturnEntity getProductSpecialPrice(Integer productId, String productSku, String productIdOrSku, String storeViewIdOrCode) {
        return this.catalogClient.getProductSpecialPrice(ProductIdentifiers.from(productSku, productId, productIdOrSku), storeViewIdOrCode);
    }

    public CatalogProductReturnEntity getProduct(Integer productId, String productSku, String productIdOrSku, String storeViewIdOrCode, List<String> attributesNames, List<String> additionalAttributeNames) {
        return this.catalogClient.getProduct(ProductIdentifiers.from(productSku, productId, productIdOrSku), storeViewIdOrCode, attributesNames, additionalAttributeNames);
    }

    public List<CatalogProductEntity> listProducts(String filter, String storeViewIdOrCode) {
        return this.catalogClient.listProducts(filter, storeViewIdOrCode);
    }

    public int updateProductSpecialPrice(Integer productId, String productSku, String productIdOrSku, String specialPrice, String fromDate, String toDate, String storeViewIdOrCode) {
        return this.catalogClient.updateProductSpecialPrice(ProductIdentifiers.from(productSku, productId, productIdOrSku), specialPrice, fromDate, toDate, storeViewIdOrCode);
    }

    public boolean updateProduct(Integer productId, String productSku, String productIdOrSku, CatalogProductCreateEntity catalogProductEntity, List<AssociativeEntity> additionalAttributes, String storeViewIdOrCode) {
        return this.catalogClient.updateProduct(ProductIdentifiers.from(productSku, productId, productIdOrSku), catalogProductEntity, additionalAttributes, storeViewIdOrCode);
    }

    public int createShoppingCart(String storeId) {
        return this.shoppingCartClient.createShoppingCart(storeId);
    }

    public ShoppingCartInfoEntity getInfoShoppingCart(int quoteId, String storeId) {
        return this.shoppingCartClient.getShoppingCartInfo(quoteId, storeId);
    }

    public List<ShoppingCartTotalsEntity> listShoppingCartTotals(int quoteId, String storeId) {
        return this.shoppingCartClient.listShoppingCartTotals(quoteId, storeId);
    }

    public String createShoppingCartOrder(int quoteId, String storeId, List<String> licenses) {
        return this.shoppingCartClient.createShoppingCartOrder(quoteId, storeId, licenses);
    }

    public List<ShoppingCartLicenseEntity> listShoppingCartLicenses(int quoteId, String storeId) {
        return this.shoppingCartClient.listShoppingCartLicenses(quoteId, storeId);
    }

    public boolean addShoppingCartProduct(int quoteId, List<ShoppingCartProductEntity> products, String storeId) {
        return this.shoppingCartClient.addShoppingCartProduct(quoteId, products, storeId);
    }

    public boolean updateShoppingCartProduct(int quoteId, List<ShoppingCartProductEntity> products, String storeId) {
        return this.shoppingCartClient.updateShoppingCartProduct(quoteId, products, storeId);
    }

    public boolean removeShoppingCartProduct(int quoteId, List<ShoppingCartProductEntity> products, String storeId) {
        return this.shoppingCartClient.removeShoppingCartProduct(quoteId, products, storeId);
    }

    public List<CatalogProductEntity> listShoppingCartProducts(int quoteId, String storeId) {
        return this.shoppingCartClient.listShoppingCartProducts(quoteId, storeId);
    }

    public boolean moveShoppingCartProductToCustomerQuote(int quoteId, List<ShoppingCartProductEntity> products, String storeId) {
        return this.shoppingCartClient.moveShoppingCartProductToCustomerQuote(quoteId, products, storeId);
    }

    public boolean setShoppingCartCustomer(int quoteId, ShoppingCartCustomerEntity customer, String storeId) {
        return this.shoppingCartClient.setShoppingCartCustomer(quoteId, customer, storeId);
    }

    public boolean setShoppingCartCustomerAddresses(int quoteId, List<ShoppingCartCustomerAddressEntity> shoppingCartCustomerAddresses, String storeId) {
        return this.shoppingCartClient.setShoppingCartCustomerAddresses(quoteId, shoppingCartCustomerAddresses, storeId);
    }

    public boolean setShoppingCartShippingMethod(int quoteId, String method, String storeId) {
        return this.shoppingCartClient.setShoppingCartShippingMethod(quoteId, method, storeId);
    }

    public List<ShoppingCartShippingMethodEntity> listShoppingCartShippingMethods(int quoteId, String storeId) {
        return this.shoppingCartClient.listShoppingCartShippingMethods(quoteId, storeId);
    }

    public boolean setShoppingCartPaymentMethod(int quoteId, ShoppingCartPaymentMethodEntity shoppingCartPaymentMethod, String storeId) {
        return this.shoppingCartClient.setShoppingCartPaymentMethod(quoteId, shoppingCartPaymentMethod, storeId);
    }

    public ShoppingCartPaymentMethodResponseEntityArray listShoppingCartPaymentMethods(int quoteId, String storeId) {
        return this.shoppingCartClient.listShoppingCartPaymentMethods(quoteId, storeId);
    }

    public boolean addShoppingCartCoupon(int quoteId, String couponCode, String storeId) {
        return this.shoppingCartClient.addShoppingCartCoupon(quoteId, couponCode, storeId);
    }

    public boolean removeShoppingCartCoupon(int quoteId, String storeId) {
        return this.shoppingCartClient.removeShoppingCartCoupon(quoteId, storeId);
    }

    public void setOrderClient(MagentoOrderClient<?> magentoOrderClient) {
        this.orderClient = MagentoClientAdaptor.adapt(MagentoOrderClient.class, magentoOrderClient);
    }

    public void setCustomerClient(MagentoCustomerClient<?> customerClient) {
        this.customerClient = MagentoClientAdaptor.adapt(MagentoCustomerClient.class, customerClient);
    }

    public void setInventoryClient(MagentoInventoryClient<?> inventoryClient) {
        this.inventoryClient = MagentoClientAdaptor.adapt(MagentoInventoryClient.class, inventoryClient);
    }

    public void setDirectoryClient(MagentoDirectoryClient<?> directoryClient) {
        this.directoryClient = MagentoClientAdaptor.adapt(MagentoDirectoryClient.class, directoryClient);
    }

    public void setCatalogClient(MagentoCatalogClient<?> catalogClient) {
        this.catalogClient = MagentoClientAdaptor.adapt(MagentoCatalogClient.class, catalogClient);
    }

    public void setShoppingCartClient(MagentoShoppingCartClient<?> catalogClient) {
        this.shoppingCartClient = MagentoClientAdaptor.adapt(MagentoShoppingCartClient.class, catalogClient);
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    private class PortProviderInitializer {
        private DefaultAxisPortProvider provider;
        private String username;
        private String password;
        private String address;

        public PortProviderInitializer(String username, String password, String address) {
            this.username = username;
            this.password = password;
            this.address = address;
        }

        public AxisPortProvider getPortProvider() {
            if (this.provider == null) {
                this.provider = new DefaultAxisPortProvider(this.username, this.password, this.address);
            }
            return this.provider;
        }
    }
}

