/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.logging;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.impl.MuleLocationAwareLog;
import org.apache.commons.logging.impl.MuleLog;
import org.apache.commons.logging.impl.SLF4JLogFactory;
import org.mule.module.logging.LoggerReferenceHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;

public class MuleLogFactory
extends SLF4JLogFactory {
    protected ConcurrentHashMap<Integer, ConcurrentMap<String, Log>> repository = new ConcurrentHashMap();
    protected static final Integer NO_CCL_CLASSLOADER = 0;
    protected ReferenceQueue<ClassLoader> referenceQueue = new ReferenceQueue();
    protected Map<PhantomReference<ClassLoader>, Integer> refs = new HashMap<PhantomReference<ClassLoader>, Integer>();

    public MuleLogFactory() {
        new LoggerReferenceHandler("Mule.log.clogging.ref.handler", this.referenceQueue, this.refs, this.repository);
    }

    public Log getInstance(String name) throws LogConfigurationException {
        Logger logger;
        Log previous;
        Log instance;
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        ConcurrentMap<String, Log> loggerMap = this.repository.get(ccl == null ? NO_CCL_CLASSLOADER.intValue() : ccl.hashCode());
        if (loggerMap == null) {
            loggerMap = new ConcurrentHashMap<String, Log>();
            ConcurrentMap<String, Log> previous2 = this.repository.putIfAbsent(ccl == null ? NO_CCL_CLASSLOADER.intValue() : ccl.hashCode(), loggerMap);
            if (previous2 != null) {
                loggerMap = previous2;
            }
            if (ccl != null) {
                this.refs.put(new PhantomReference<ClassLoader>(ccl, this.referenceQueue), ccl.hashCode());
            }
        }
        if ((instance = (Log)loggerMap.get(name)) == null && (previous = loggerMap.putIfAbsent(name, instance = (logger = LoggerFactory.getLogger(name)) instanceof LocationAwareLogger ? new MuleLocationAwareLog((LocationAwareLogger)logger) : new MuleLog(logger))) != null) {
            instance = previous;
        }
        return instance;
    }
}

