/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.launcher.log4j2;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.logging.log4j.core.LoggerContext;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.DirectoryResourceLocator;
import org.mule.runtime.module.artifact.classloader.LocalResourceLocator;
import org.mule.runtime.module.artifact.classloader.ShutdownListener;
import org.mule.runtime.module.launcher.log4j2.ArtifactAwareContextSelector;
import org.mule.runtime.module.launcher.log4j2.MuleLoggerContext;
import org.mule.runtime.module.reboot.MuleContainerBootstrapUtils;

public class MuleLoggerContextFactory {
    public LoggerContext build(final ClassLoader classLoader, final ArtifactAwareContextSelector selector) {
        NewContextParameters parameters = this.resolveContextParameters(classLoader);
        if (parameters == null) {
            return this.getDefaultContext(selector);
        }
        MuleLoggerContext loggerContext = new MuleLoggerContext(parameters.contextName, parameters.loggerConfigFile, classLoader, selector, this.isStandalone());
        if (classLoader instanceof ArtifactClassLoader) {
            ArtifactClassLoader artifactClassLoader = (ArtifactClassLoader)classLoader;
            artifactClassLoader.addShutdownListener(new ShutdownListener(){

                public void execute() {
                    selector.destroyLoggersFor(ArtifactAwareContextSelector.resolveLoggerContextClassLoader(classLoader));
                }
            });
        }
        return loggerContext;
    }

    private NewContextParameters resolveContextParameters(ClassLoader classLoader) {
        if (classLoader instanceof ArtifactClassLoader) {
            ArtifactClassLoader artifactClassLoader = (ArtifactClassLoader)classLoader;
            return new NewContextParameters(this.getArtifactLoggingConfig(artifactClassLoader), artifactClassLoader.getArtifactId());
        }
        if (MuleContainerBootstrapUtils.getMuleConfDir() != null) {
            return new NewContextParameters(this.getLogConfig((LocalResourceLocator)new DirectoryResourceLocator(new String[]{MuleContainerBootstrapUtils.getMuleConfDir().getAbsolutePath()})), classLoader.toString());
        }
        return null;
    }

    private URI getArtifactLoggingConfig(ArtifactClassLoader muleCL) {
        URI appLogConfig;
        try {
            ApplicationDescriptor appDescriptor = (ApplicationDescriptor)muleCL.getArtifactDescriptor();
            if (appDescriptor.getLogConfigFile() == null) {
                appLogConfig = this.getLogConfig((LocalResourceLocator)muleCL);
            } else if (!appDescriptor.getLogConfigFile().exists()) {
                ArtifactAwareContextSelector.logger.warn("Configured 'log.configFile' in app descriptor points to a non-existant file. Using default configuration.");
                appLogConfig = this.getLogConfig((LocalResourceLocator)muleCL);
            } else {
                appLogConfig = appDescriptor.getLogConfigFile().toURI();
            }
        }
        catch (Exception e) {
            ArtifactAwareContextSelector.logger.warn("{} while looking for 'log.configFile' entry in app descriptor: {}. Using default configuration.", new Object[]{e.getClass().getName(), e.getMessage()});
            appLogConfig = this.getLogConfig((LocalResourceLocator)muleCL);
        }
        if (appLogConfig != null && ArtifactAwareContextSelector.logger.isInfoEnabled()) {
            ArtifactAwareContextSelector.logger.info("Found logging config for application '{}' at '{}'", new Object[]{muleCL.getArtifactId(), appLogConfig});
        }
        return appLogConfig;
    }

    private LoggerContext getDefaultContext(ArtifactAwareContextSelector selector) {
        return new MuleLoggerContext("Default", selector, this.isStandalone());
    }

    private boolean isStandalone() {
        return MuleContainerBootstrapUtils.getMuleConfDir() != null;
    }

    private URI getLogConfig(LocalResourceLocator localResourceLocator) {
        URL appLogConfig = localResourceLocator.findLocalResource("log4j2-test.xml");
        if (appLogConfig == null) {
            appLogConfig = localResourceLocator.findLocalResource("log4j2.xml");
        }
        if (appLogConfig == null) {
            File defaultConfigFile = new File(MuleContainerBootstrapUtils.getMuleHome(), "conf");
            defaultConfigFile = new File(defaultConfigFile, "log4j2.xml");
            try {
                appLogConfig = defaultConfigFile.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not locate log config in MULE_HOME"), (Throwable)e);
            }
        }
        try {
            return appLogConfig.toURI();
        }
        catch (URISyntaxException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not read log file " + appLogConfig)), (Throwable)e);
        }
    }

    private class NewContextParameters {
        private final URI loggerConfigFile;
        private final String contextName;

        private NewContextParameters(URI loggerConfigFile, String contextName) {
            this.loggerConfigFile = loggerConfigFile;
            this.contextName = contextName;
        }
    }
}

