/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.launcher.log4j2;

import com.google.common.base.Predicate;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.message.MessageFactory;
import org.mule.runtime.core.logging.LogConfigChangeSubject;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.RegionClassLoader;
import org.mule.runtime.module.launcher.log4j2.DispatchingLogger;
import org.mule.runtime.module.launcher.log4j2.LoggerContextConfigurer;
import org.reflections.ReflectionUtils;

class MuleLoggerContext
extends LoggerContext
implements LogConfigChangeSubject {
    private final LoggerContextConfigurer loggerContextConfigurer = new LoggerContextConfigurer();
    private final URI configFile;
    private final boolean standlone;
    private final ContextSelector contextSelector;
    private final boolean artifactClassloader;
    private final boolean applicationClassloader;
    private final String artifactName;
    private final int ownerClassLoaderHash;
    private final Field loggersField;

    MuleLoggerContext(String name, ContextSelector contextSelector, boolean standalone) {
        this(name, null, null, contextSelector, standalone);
    }

    MuleLoggerContext(String name, URI configLocn, ClassLoader ownerClassLoader, ContextSelector contextSelector, boolean standalone) {
        super(name, null, configLocn);
        int n;
        this.configFile = configLocn;
        this.contextSelector = contextSelector;
        this.standlone = standalone;
        if (ownerClassLoader != null) {
            n = ownerClassLoader.hashCode();
        } else {
            ((Object)((Object)this)).getClass().getClassLoader();
            n = this.ownerClassLoaderHash = ClassLoader.getSystemClassLoader().hashCode();
        }
        if (ownerClassLoader instanceof ArtifactClassLoader) {
            this.artifactClassloader = true;
            this.artifactName = this.getArtifactName((ArtifactClassLoader)ownerClassLoader);
            this.applicationClassloader = ownerClassLoader instanceof RegionClassLoader;
        } else {
            this.artifactClassloader = false;
            this.applicationClassloader = false;
            this.artifactName = null;
        }
        Set candidateFields = ReflectionUtils.getAllFields(LoggerContext.class, (Predicate[])new Predicate[]{ReflectionUtils.withName((String)"loggers")});
        if (candidateFields.size() == 1) {
            this.loggersField = (Field)candidateFields.iterator().next();
            this.loggersField.setAccessible(true);
        } else {
            this.loggersField = null;
        }
    }

    private String getArtifactName(ArtifactClassLoader ownerClassLoader) {
        return ownerClassLoader.getArtifactDescriptor().getName();
    }

    public synchronized void reconfigure() {
        this.loggerContextConfigurer.configure(this);
        super.reconfigure();
    }

    public void updateLoggers(Configuration config) {
        this.loggerContextConfigurer.update(this);
        super.updateLoggers(config);
    }

    public void registerLogConfigChangeListener(PropertyChangeListener logConfigChangeListener) {
        this.addPropertyChangeListener(logConfigChangeListener);
    }

    public void unregisterLogConfigChangeListener(PropertyChangeListener logConfigChangeListener) {
        this.removePropertyChangeListener(logConfigChangeListener);
    }

    protected Logger newInstance(LoggerContext ctx, final String name, MessageFactory messageFactory) {
        return new DispatchingLogger(super.newInstance(ctx, name, messageFactory), this.ownerClassLoaderHash, this, this.contextSelector, messageFactory){

            public String getName() {
                return name;
            }
        };
    }

    private ConcurrentMap<String, Logger> lookupLoggersField() {
        try {
            return (ConcurrentMap)this.loggersField.get((Object)this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Logger getLogger(String name, MessageFactory messageFactory) {
        Logger logger = (Logger)this.lookupLoggersField().get(name);
        if (logger != null) {
            return logger;
        }
        logger = this.newInstance(this, name, messageFactory);
        Logger prev = this.lookupLoggersField().putIfAbsent(name, logger);
        return prev == null ? logger : prev;
    }

    protected URI getConfigFile() {
        return this.configFile;
    }

    protected boolean isStandlone() {
        return this.standlone;
    }

    protected boolean isArtifactClassloader() {
        return this.artifactClassloader;
    }

    protected boolean isApplicationClassloader() {
        return this.applicationClassloader;
    }

    protected String getArtifactName() {
        return this.artifactName;
    }
}

