/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.launcher;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.agent.Agent;
import org.mule.runtime.core.config.MuleManifest;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.util.NetworkUtils;
import org.mule.runtime.core.util.SecurityUtils;
import org.mule.runtime.core.util.SplashScreen;
import org.mule.runtime.core.util.StringUtils;

public class MuleContainerStartupSplashScreen
extends SplashScreen {
    public void doBody() {
        String notset = CoreMessages.notSet().getMessage();
        Manifest mf = MuleManifest.getManifest();
        Attributes att = mf.getMainAttributes();
        if (att.values().size() > 0) {
            this.doBody(StringUtils.defaultString((String)MuleManifest.getProductDescription(), (String)notset));
            this.doBody(String.format("%s Build: %s", CoreMessages.version().getMessage(), StringUtils.defaultString((String)MuleManifest.getBuildNumber(), (String)notset)));
            this.doBody(StringUtils.defaultString((String)MuleManifest.getVendorName(), (String)notset));
            this.doBody(StringUtils.defaultString((String)MuleManifest.getProductMoreInfo(), (String)notset));
        } else {
            this.doBody(CoreMessages.versionNotSet().getMessage());
        }
        this.doBody(" ");
        this.doBody(CoreMessages.serverStartedAt((long)System.currentTimeMillis()).getMessage());
        this.doBody(String.format("JDK: %s (%s)", System.getProperty("java.version"), System.getProperty("java.vm.info")));
        String patch = System.getProperty("sun.os.patch.level", null);
        this.doBody(String.format("OS: %s%s (%s, %s)", System.getProperty("os.name"), patch != null && !"unknown".equalsIgnoreCase(patch) ? " - " + patch : "", System.getProperty("os.version"), System.getProperty("os.arch")));
        try {
            InetAddress host = NetworkUtils.getLocalHost();
            this.doBody(String.format("Host: %s (%s)", host.getHostName(), host.getHostAddress()));
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (!SecurityUtils.isDefaultSecurityModel()) {
            this.doBody("Security model: " + SecurityUtils.getSecurityModel());
        }
        if (RUNTIME_VERBOSE_PROPERTY.isEnabled()) {
            this.listPatchesIfPresent();
            this.listMuleSystemProperties();
        }
    }

    private void listPatchesIfPresent() {
        File patchesDirectory = MuleFoldersUtil.getUserLibFolder();
        if (patchesDirectory != null && patchesDirectory.exists()) {
            Object[] patches = patchesDirectory.list((dir, name) -> name.startsWith("SE-"));
            Arrays.sort(patches);
            this.listItems(Arrays.asList(patches), "Applied patches:");
        }
    }

    private void listMuleSystemProperties() {
        HashMap muleProperties = new HashMap();
        System.getProperties().stringPropertyNames().stream().filter(property -> property.startsWith("mule.")).forEach(property -> muleProperties.put(property, System.getProperty(property)));
        this.listItems(muleProperties, "Mule system properties:");
    }

    protected void doFooter(MuleContext context) {
        Collection agents;
        if (!this.body.isEmpty()) {
            this.footer.add(" ");
        }
        if ((agents = context.getRegistry().lookupObjects(Agent.class)).size() == 0) {
            this.footer.add(CoreMessages.agentsRunning().getMessage() + " " + CoreMessages.none().getMessage());
        } else {
            this.footer.add(CoreMessages.agentsRunning().getMessage());
            for (Agent agent : agents) {
                this.footer.add("  " + agent.getDescription());
            }
        }
    }
}

