/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher.domain;

import com.google.common.base.Optional;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.mule.module.launcher.DeploymentListener;
import org.mule.module.launcher.DeploymentPropertiesUtils;
import org.mule.module.launcher.MuleFoldersUtil;
import org.mule.module.launcher.application.builder.DefaultMuleDomainBuilder;
import org.mule.module.launcher.artifact.ArtifactFactoryUtils;
import org.mule.module.launcher.descriptor.DomainDescriptor;
import org.mule.module.launcher.descriptor.DomainDescriptorParser;
import org.mule.module.launcher.descriptor.EmptyDomainDescriptor;
import org.mule.module.launcher.domain.DefaultMuleDomain;
import org.mule.module.launcher.domain.Domain;
import org.mule.module.launcher.domain.DomainClassLoaderRepository;
import org.mule.module.launcher.domain.DomainFactory;
import org.mule.module.launcher.domain.DomainWrapper;
import org.mule.module.reboot.MuleContainerBootstrapUtils;

public class DefaultDomainFactory
implements DomainFactory {
    private final DomainClassLoaderRepository domainClassLoaderRepository;
    private final Map<String, Domain> domains = new HashMap<String, Domain>();
    private final DomainDescriptorParser domainDescriptorParser;
    protected DeploymentListener deploymentListener;

    public DefaultDomainFactory(DomainClassLoaderRepository domainClassLoaderRepository) {
        this.domainClassLoaderRepository = domainClassLoaderRepository;
        this.domainDescriptorParser = new DomainDescriptorParser();
    }

    public void setDeploymentListener(DeploymentListener deploymentListener) {
        this.deploymentListener = deploymentListener;
    }

    @Override
    public Domain createDefaultDomain() throws IOException {
        return this.createArtifact("default");
    }

    @Override
    public Domain createArtifact(String artifactName, Optional<Properties> deploymentProperties) throws IOException {
        if (this.domains.containsKey(artifactName)) {
            return this.domains.get(artifactName);
        }
        if (artifactName.contains(" ")) {
            throw new IllegalArgumentException("Mule application name may not contain spaces: " + artifactName);
        }
        DomainDescriptor descriptor = this.findDomain(artifactName);
        DefaultMuleDomain defaultMuleDomain = this.createDefaultMuleDomain(this.domainClassLoaderRepository, descriptor, deploymentProperties);
        defaultMuleDomain.setDeploymentListener(this.deploymentListener);
        DomainWrapper domainWrapper = new DomainWrapper(defaultMuleDomain, this);
        this.domains.put(artifactName, domainWrapper);
        return domainWrapper;
    }

    private DefaultMuleDomain createDefaultMuleDomain(DomainClassLoaderRepository domainClassLoaderRepository, DomainDescriptor descriptor, Optional<Properties> deploymentProperties) throws IOException {
        DefaultMuleDomainBuilder builder = new DefaultMuleDomainBuilder();
        builder.setDescriptor(descriptor);
        builder.setDomainClassLoaderRepository(domainClassLoaderRepository);
        builder.setDeploymentProperties(DeploymentPropertiesUtils.resolveDeploymentProperties(descriptor.getName(), deploymentProperties));
        return builder.buildDomain();
    }

    private DomainDescriptor findDomain(String domainName) throws IOException {
        DomainDescriptor descriptor;
        if ("default".equals(domainName)) {
            return new EmptyDomainDescriptor("default");
        }
        File deploymentFile = ArtifactFactoryUtils.getDeploymentFile(MuleFoldersUtil.getDomainFolder(domainName), domainName, "mule-deploy.properties");
        if (deploymentFile != null) {
            descriptor = this.domainDescriptorParser.parse(deploymentFile);
            descriptor.setName(domainName);
        } else {
            descriptor = new EmptyDomainDescriptor(domainName);
        }
        return descriptor;
    }

    @Override
    public File getArtifactDir() {
        return MuleContainerBootstrapUtils.getMuleDomainsDir();
    }

    public void dispose(DomainWrapper domain) {
        this.domains.remove(domain.getArtifactName());
    }

    public void start(DomainWrapper domainWrapper) {
        this.domains.put(domainWrapper.getArtifactName(), domainWrapper);
    }

    @Override
    public Domain createArtifact(String artifactName) throws IOException {
        Optional properties = Optional.absent();
        return this.createArtifact(artifactName, properties);
    }
}

