/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher.artifact;

import java.io.File;
import java.util.Collection;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.mule.api.MuleRuntimeException;
import org.mule.config.i18n.MessageFactory;
import org.mule.util.FileUtils;

public class ArtifactFactoryUtils {
    private ArtifactFactoryUtils() {
    }

    public static File getDeploymentFile(File artifactDir, String artifactName, String pattern) {
        if (!artifactDir.exists()) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage((String)String.format("Artifact directory does not exist: '%s'", artifactDir)));
        }
        Collection deployFiles = FileUtils.listFiles((File)artifactDir, (IOFileFilter)new WildcardFileFilter(pattern), null);
        if (deployFiles.size() > 1) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage((String)String.format("More than one mule-deploy descriptors found in artifact '%s'", artifactName)));
        }
        if (deployFiles.isEmpty()) {
            return null;
        }
        return (File)deployFiles.iterator().next();
    }
}

