/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher.artifact;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.module.launcher.DirectoryResourceLocator;
import org.mule.module.launcher.FineGrainedControlClassLoader;
import org.mule.module.launcher.LocalResourceLocator;
import org.mule.module.launcher.artifact.ArtifactClassLoader;
import org.mule.module.launcher.artifact.ResourceReleaser;
import org.mule.module.launcher.artifact.ShutdownListener;

public abstract class AbstractArtifactClassLoader
extends FineGrainedControlClassLoader
implements ArtifactClassLoader {
    private static final String DEFAULT_RESOURCE_RELEASER_CLASS_LOCATION = "/org/mule/module/launcher/artifact/DefaultResourceReleaser.class";
    protected Log logger = LogFactory.getLog(this.getClass());
    protected List<ShutdownListener> shutdownListeners = new ArrayList<ShutdownListener>();
    private LocalResourceLocator localResourceLocator;
    private String resourceReleaserClassLocation = "/org/mule/module/launcher/artifact/DefaultResourceReleaser.class";

    public AbstractArtifactClassLoader(URL[] urls, ClassLoader parent) {
        this(urls, parent, Collections.emptySet());
    }

    public AbstractArtifactClassLoader(URL[] urls, ClassLoader parent, Set<String> overrides) {
        super(urls, parent, overrides);
    }

    @Override
    public void addShutdownListener(ShutdownListener listener) {
        this.shutdownListeners.add(listener);
    }

    @Override
    public void dispose() {
        try {
            this.createResourceReleaserInstance().release();
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        super.dispose();
        this.shutdownListeners();
    }

    private void shutdownListeners() {
        for (ShutdownListener listener : this.shutdownListeners) {
            try {
                listener.execute();
            }
            catch (Exception e) {
                this.logger.error((Object)e);
            }
        }
        this.shutdownListeners.clear();
    }

    public void setResourceReleaserClassLocation(String resourceReleaserClassLocation) {
        this.resourceReleaserClassLocation = resourceReleaserClassLocation;
    }

    protected ResourceReleaser createResourceReleaserInstance() {
        ResourceReleaser resourceReleaser;
        InputStream classStream = null;
        try {
            classStream = this.getClass().getResourceAsStream(this.resourceReleaserClassLocation);
            byte[] classBytes = org.mule.util.IOUtils.toByteArray((InputStream)classStream);
            classStream.close();
            Class<?> clazz = this.defineClass(null, classBytes, 0, classBytes.length);
            resourceReleaser = (ResourceReleaser)clazz.newInstance();
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("Can not create resource releaser instance from resource: " + this.resourceReleaserClassLocation, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(classStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)classStream);
        return resourceReleaser;
    }

    @Override
    public URL findLocalResource(String resourceName) {
        URL resource = this.getLocalResourceLocator().findLocalResource(resourceName);
        if (resource == null && this.getParent() instanceof LocalResourceLocator) {
            resource = ((LocalResourceLocator)((Object)this.getParent())).findLocalResource(resourceName);
        }
        return resource;
    }

    private LocalResourceLocator getLocalResourceLocator() {
        if (this.localResourceLocator == null) {
            this.localResourceLocator = new DirectoryResourceLocator(this.getLocalResourceLocations());
        }
        return this.localResourceLocator;
    }

    protected abstract String[] getLocalResourceLocations();

    static {
        AbstractArtifactClassLoader.registerAsParallelCapable();
    }
}

