/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.mule.module.launcher.ArchiveDeployer;
import org.mule.module.launcher.DeploymentDirectoryWatcher;
import org.mule.module.launcher.application.Application;
import org.mule.module.launcher.domain.Domain;
import org.mule.module.launcher.util.ObservableList;
import org.mule.util.concurrent.WaitPolicy;

public class ParallelDeploymentDirectoryWatcher
extends DeploymentDirectoryWatcher {
    private final ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(0, 20, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (RejectedExecutionHandler)new WaitPolicy());

    public ParallelDeploymentDirectoryWatcher(ArchiveDeployer<Domain> domainArchiveDeployer, ArchiveDeployer<Application> applicationArchiveDeployer, ObservableList<Domain> domains, ObservableList<Application> applications, ReentrantLock deploymentLock) {
        super(domainArchiveDeployer, applicationArchiveDeployer, domains, applications, deploymentLock);
    }

    @Override
    protected void deployPackedApps(String[] zips) {
        if (zips.length == 0) {
            return;
        }
        ArrayList<Callable<Object>> tasks = new ArrayList<Callable<Object>>(zips.length);
        for (final String zip : zips) {
            tasks.add(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    try {
                        ParallelDeploymentDirectoryWatcher.this.applicationArchiveDeployer.deployPackagedArtifact(zip);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                }
            });
        }
        this.waitForTasksToFinish(tasks);
    }

    @Override
    protected void deployExplodedApps(String[] apps) {
        ArrayList<Callable<Object>> tasks = new ArrayList<Callable<Object>>(apps.length);
        for (final String addedApp : apps) {
            if (!this.applicationArchiveDeployer.isUpdatedZombieArtifact(addedApp)) continue;
            tasks.add(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    try {
                        ParallelDeploymentDirectoryWatcher.this.applicationArchiveDeployer.deployExplodedArtifact(addedApp);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                }
            });
        }
        if (!tasks.isEmpty()) {
            this.waitForTasksToFinish(tasks);
        }
    }

    private void waitForTasksToFinish(List<Callable<Object>> tasks) {
        try {
            List<Future<Object>> futures = this.threadPoolExecutor.invokeAll(tasks);
            for (Future<Object> future : futures) {
                try {
                    future.get();
                }
                catch (ExecutionException executionException) {}
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

