/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher.coreextension;

import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleCoreExtension;
import org.mule.api.DefaultMuleException;
import org.mule.module.launcher.coreextension.MuleCoreExtensionDiscoverer;
import org.mule.util.ClassUtils;

public class ClasspathMuleCoreExtensionDiscoverer
implements MuleCoreExtensionDiscoverer {
    public static final String SERVICE_PATH = "META-INF/services/org/mule/config/";
    public static final String CORE_EXTENSION_PROPERTIES = "core-extensions.properties";
    private static Log logger = LogFactory.getLog(ClasspathMuleCoreExtensionDiscoverer.class);

    @Override
    public List<MuleCoreExtension> discover() throws DefaultMuleException {
        LinkedList<MuleCoreExtension> result = new LinkedList<MuleCoreExtension>();
        Enumeration e = ClassUtils.getResources((String)"META-INF/services/org/mule/config/core-extensions.properties", this.getClass());
        LinkedList<Properties> extensions = new LinkedList<Properties>();
        while (e.hasMoreElements()) {
            try {
                URL url = (URL)e.nextElement();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Reading extension file: " + url.toString()));
                }
                Properties p = new Properties();
                p.load(url.openStream());
                extensions.add(p);
            }
            catch (Exception ex) {
                throw new DefaultMuleException("Error loading Mule core extensions", (Throwable)ex);
            }
        }
        for (Properties extProps : extensions) {
            for (Map.Entry<Object, Object> entry : extProps.entrySet()) {
                String extName = (String)entry.getKey();
                String extClass = (String)entry.getValue();
                try {
                    MuleCoreExtension extension = (MuleCoreExtension)ClassUtils.instanciateClass((String)extClass, (Object[])new Object[0]);
                    result.add(extension);
                }
                catch (Exception ex) {
                    throw new DefaultMuleException("Error starting Mule core extension " + extName, (Throwable)ex);
                }
            }
        }
        return result;
    }
}

