/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.module.launcher.AbstractDeploymentListener;

public class ArtifactDeploymentStatusTracker
extends AbstractDeploymentListener {
    protected Map<String, DeploymentState> deploymentStates = new ConcurrentHashMap<String, DeploymentState>();

    public Map<String, DeploymentState> getDeploymentStates() {
        return Collections.unmodifiableMap(this.deploymentStates);
    }

    @Override
    public void onDeploymentStart(String artifactName) {
        this.deploymentStates.put(artifactName, DeploymentState.DEPLOYING);
    }

    @Override
    public void onDeploymentSuccess(String artifactName) {
        this.deploymentStates.put(artifactName, DeploymentState.DEPLOYED);
    }

    @Override
    public void onDeploymentFailure(String artifactName, Throwable failureCause) {
        this.deploymentStates.put(artifactName, DeploymentState.FAILED);
    }

    public static enum DeploymentState {
        DEPLOYING,
        FAILED,
        DEPLOYED;

    }
}

