/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher.application;

import java.util.HashMap;
import java.util.Map;
import org.mule.module.launcher.application.ApplicationStatus;

public class ApplicationStatusMapper {
    private static Map<String, ApplicationStatus> statusMapping;

    public static ApplicationStatus getApplicationStatus(String currentPhase) {
        ApplicationStatus applicationStatus = ApplicationStatusMapper.getStatusMapping().get(currentPhase);
        if (applicationStatus == null) {
            throw new IllegalStateException("Unknown lifecycle phase: " + currentPhase);
        }
        return applicationStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<String, ApplicationStatus> getStatusMapping() {
        if (statusMapping != null) return statusMapping;
        Class<ApplicationStatusMapper> clazz = ApplicationStatusMapper.class;
        synchronized (ApplicationStatusMapper.class) {
            if (statusMapping != null) return statusMapping;
            statusMapping = new HashMap<String, ApplicationStatus>();
            statusMapping.put("not in lifecycle", ApplicationStatus.CREATED);
            statusMapping.put("dispose", ApplicationStatus.DESTROYED);
            statusMapping.put("stop", ApplicationStatus.STOPPED);
            statusMapping.put("start", ApplicationStatus.STARTED);
            statusMapping.put("initialise", ApplicationStatus.INITIALISED);
            // ** MonitorExit[var0] (shouldn't be in output)
            return statusMapping;
        }
    }
}

