/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher.coreextension;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.mule.MuleCoreExtension;
import org.mule.api.MuleRuntimeException;
import org.mule.module.launcher.coreextension.LinkedMuleCoreExtensionDependency;
import org.mule.module.launcher.coreextension.MuleCoreExtensionDependencyDiscoverer;
import org.mule.module.launcher.coreextension.MuleCoreExtensionDependencyResolver;
import org.mule.module.launcher.coreextension.ReflectionMuleCoreExtensionDependencyDiscoverer;
import org.mule.module.launcher.coreextension.UnresolveableDependencyException;

public class ReflectionMuleCoreExtensionDependencyResolver
implements MuleCoreExtensionDependencyResolver {
    private final MuleCoreExtensionDependencyDiscoverer dependencyDiscoverer;

    public ReflectionMuleCoreExtensionDependencyResolver() {
        this(new ReflectionMuleCoreExtensionDependencyDiscoverer());
    }

    public ReflectionMuleCoreExtensionDependencyResolver(MuleCoreExtensionDependencyDiscoverer dependencyDiscoverer) {
        this.dependencyDiscoverer = dependencyDiscoverer;
    }

    @Override
    public List<MuleCoreExtension> resolveDependencies(Collection<MuleCoreExtension> coreExtensions) {
        LinkedList<MuleCoreExtension> unresolvedExtensions = new LinkedList<MuleCoreExtension>(coreExtensions);
        LinkedList<MuleCoreExtension> resolvedExtensions = new LinkedList<MuleCoreExtension>();
        boolean continueResolution = true;
        while (continueResolution) {
            int initialResolvedCount = resolvedExtensions.size();
            LinkedList<MuleCoreExtension> pendingUnresolvedExtensions = new LinkedList<MuleCoreExtension>();
            for (MuleCoreExtension muleCoreExtension : unresolvedExtensions) {
                boolean resolvedDependency = this.isResolvedDependency(resolvedExtensions, muleCoreExtension);
                if (resolvedDependency) {
                    resolvedExtensions.add(muleCoreExtension);
                    continue;
                }
                pendingUnresolvedExtensions.add(muleCoreExtension);
            }
            unresolvedExtensions = pendingUnresolvedExtensions;
            continueResolution = resolvedExtensions.size() > initialResolvedCount;
        }
        if (unresolvedExtensions.size() != 0) {
            throw new UnresolveableDependencyException("Unable to resolve core extension dependencies: " + unresolvedExtensions);
        }
        return resolvedExtensions;
    }

    private boolean isResolvedDependency(List<MuleCoreExtension> resolvedExtensions, MuleCoreExtension muleCoreExtension) {
        boolean resolvedDependency = false;
        List<LinkedMuleCoreExtensionDependency> dependencies = this.dependencyDiscoverer.findDependencies(muleCoreExtension);
        if (dependencies.size() == 0) {
            resolvedDependency = true;
        } else if (this.satisfiedDependencies(dependencies, resolvedExtensions)) {
            this.injectDependencies(muleCoreExtension, resolvedExtensions, dependencies);
            resolvedDependency = true;
        }
        return resolvedDependency;
    }

    private void injectDependencies(MuleCoreExtension muleCoreExtension, List<MuleCoreExtension> resolvedExtensions, List<LinkedMuleCoreExtensionDependency> dependencies) {
        for (LinkedMuleCoreExtensionDependency linkedMuleCoreExtensionDependency : dependencies) {
            MuleCoreExtension dependencyInstance = this.findDependencyInstance(resolvedExtensions, linkedMuleCoreExtensionDependency.getDependencyClass());
            try {
                linkedMuleCoreExtensionDependency.getDependantMethod().invoke((Object)muleCoreExtension, dependencyInstance);
            }
            catch (Exception e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
    }

    private MuleCoreExtension findDependencyInstance(List<MuleCoreExtension> resolvedExtensions, Class<? extends MuleCoreExtension> dependencyClass) {
        for (MuleCoreExtension coreExtension : resolvedExtensions) {
            if (!dependencyClass.isAssignableFrom(coreExtension.getClass())) continue;
            return coreExtension;
        }
        throw new IllegalArgumentException("Unable to find an instance for " + dependencyClass);
    }

    private boolean satisfiedDependencies(List<LinkedMuleCoreExtensionDependency> dependencies, List<MuleCoreExtension> resolvedExtensions) {
        for (LinkedMuleCoreExtensionDependency dependency : dependencies) {
            boolean isResolved = false;
            for (MuleCoreExtension resolved : resolvedExtensions) {
                if (!dependency.getDependencyClass().isAssignableFrom(resolved.getClass())) continue;
                isResolved = true;
            }
            if (isResolved) continue;
            return false;
        }
        return true;
    }
}

