/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.LogManager;
import org.apache.log4j.spi.RepositorySelector;
import org.mule.MuleCoreExtension;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleException;
import org.mule.config.ExceptionHelper;
import org.mule.config.StartupContext;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.Message;
import org.mule.module.launcher.DeploymentService;
import org.mule.module.launcher.MuleContainerStartupSplashScreen;
import org.mule.module.launcher.log4j.ApplicationAwareRepositorySelector;
import org.mule.util.ClassUtils;
import org.mule.util.MuleUrlStreamHandlerFactory;
import org.mule.util.StringMessageUtils;
import org.mule.util.SystemUtils;

public class MuleContainer {
    public static final String[][] CLI_OPTIONS = new String[][]{{"builder", "true", "Configuration Builder Type"}, {"config", "true", "Configuration File"}, {"idle", "false", "Whether to run in idle (unconfigured) mode"}, {"main", "true", "Main Class"}, {"mode", "true", "Run Mode"}, {"props", "true", "Startup Properties"}, {"production", "false", "Production Mode"}, {"debug", "false", "Configure Mule for JPDA remote debugging."}, {"app", "true", "Application to start"}};
    public static final String SERVICE_PATH = "META-INF/services/org/mule/config/";
    public static final String CORE_EXTENSION_PROPERTIES = "core-extensions.properties";
    private static Log logger;
    private static String startupPropertiesFile;
    private static MuleShutdownHook muleShutdownHook;
    protected DeploymentService deploymentService;
    protected Map<Class<? extends MuleCoreExtension>, MuleCoreExtension> coreExtensions = new HashMap<Class<? extends MuleCoreExtension>, MuleCoreExtension>();

    public static void main(String[] args) throws Exception {
        MuleContainer container = new MuleContainer(args);
        container.start(true);
    }

    public MuleContainer() {
        this.init(new String[0]);
    }

    public MuleContainer(String[] args) throws IllegalArgumentException {
        this.init(args);
    }

    protected void init(String[] args) throws IllegalArgumentException {
        Map commandlineOptions;
        try {
            commandlineOptions = SystemUtils.getCommandLineOptions((String[])args, (String[][])CLI_OPTIONS);
        }
        catch (DefaultMuleException me) {
            throw new IllegalArgumentException(me.toString());
        }
        MuleUrlStreamHandlerFactory.installUrlStreamHandlerFactory();
        String propertiesFile = (String)commandlineOptions.get("props");
        if (propertiesFile != null) {
            MuleContainer.setStartupPropertiesFile(propertiesFile);
        }
        StartupContext.get().setStartupOptions(commandlineOptions);
    }

    public void start(boolean registerShutdownHook) {
        if (registerShutdownHook) {
            this.registerShutdownHook();
        }
        MuleContainerStartupSplashScreen splashScreen = new MuleContainerStartupSplashScreen();
        splashScreen.doBody();
        logger.info((Object)splashScreen.toString());
        try {
            this.loadCoreExtensions();
            this.deploymentService = new DeploymentService(this.coreExtensions);
            this.deploymentService.start();
        }
        catch (Throwable e) {
            this.shutdown(e);
        }
    }

    private void loadCoreExtensions() throws MuleException {
        Enumeration e = ClassUtils.getResources((String)"META-INF/services/org/mule/config/core-extensions.properties", this.getClass());
        LinkedList<Properties> extensions = new LinkedList<Properties>();
        while (e.hasMoreElements()) {
            try {
                URL url = (URL)e.nextElement();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Reading extension file: " + url.toString()));
                }
                Properties p = new Properties();
                p.load(url.openStream());
                extensions.add(p);
            }
            catch (Exception ex) {
                throw new DefaultMuleException("Error loading Mule core extensions", (Throwable)ex);
            }
        }
        for (Properties extProps : extensions) {
            for (Map.Entry<Object, Object> entry : extProps.entrySet()) {
                String extName = (String)entry.getKey();
                String extClass = (String)entry.getValue();
                try {
                    MuleCoreExtension extension = (MuleCoreExtension)ClassUtils.instanciateClass((String)extClass, (Object[])new Object[0]);
                    extension.initialise();
                    this.coreExtensions.put(extension.getClass(), extension);
                }
                catch (Exception ex) {
                    throw new DefaultMuleException("Error starting Mule core extension " + extName, (Throwable)ex);
                }
            }
        }
    }

    public void shutdown(Throwable e) {
        Message msg = CoreMessages.fatalErrorWhileRunning();
        MuleException muleException = ExceptionHelper.getRootMuleException((Throwable)e);
        if (muleException != null) {
            logger.fatal((Object)muleException.getDetailedMessage());
        } else {
            logger.fatal((Object)(msg.toString() + " " + e.getMessage()), e);
        }
        ArrayList<String> msgs = new ArrayList<String>();
        msgs.add(msg.getMessage());
        Throwable root = ExceptionHelper.getRootException((Throwable)e);
        msgs.add(root.getMessage() + " (" + root.getClass().getName() + ")");
        msgs.add(" ");
        msgs.add(CoreMessages.fatalErrorInShutdown().getMessage());
        String shutdownMessage = StringMessageUtils.getBoilerPlate(msgs, (char)'*', (int)80);
        logger.fatal((Object)shutdownMessage);
        this.unregisterShutdownHook();
        this.doShutdown();
    }

    public void shutdown() {
        logger.info((Object)"Mule container shutting down due to normal shutdown request");
        this.unregisterShutdownHook();
        this.doShutdown();
    }

    protected void doShutdown() {
        if (this.deploymentService != null) {
            this.deploymentService.stop();
        }
        for (MuleCoreExtension extension : this.coreExtensions.values()) {
            try {
                extension.dispose();
            }
            catch (Exception ex) {
                logger.fatal((Object)("Error shutting down core extension " + extension.getName()));
            }
        }
        System.exit(0);
    }

    public Log getLogger() {
        return logger;
    }

    public void registerShutdownHook() {
        if (muleShutdownHook == null) {
            muleShutdownHook = new MuleShutdownHook();
        } else {
            Runtime.getRuntime().removeShutdownHook(muleShutdownHook);
        }
        Runtime.getRuntime().addShutdownHook(muleShutdownHook);
    }

    public void unregisterShutdownHook() {
        if (muleShutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(muleShutdownHook);
        }
    }

    public static String getStartupPropertiesFile() {
        return startupPropertiesFile;
    }

    public static void setStartupPropertiesFile(String startupPropertiesFile) {
        MuleContainer.startupPropertiesFile = startupPropertiesFile;
    }

    static {
        startupPropertiesFile = null;
        if (System.getProperty("mule.simpleLog") == null) {
            LogManager.setRepositorySelector((RepositorySelector)new ApplicationAwareRepositorySelector(), (Object)new Object());
        }
        logger = LogFactory.getLog(MuleContainer.class);
    }

    private class MuleShutdownHook
    extends Thread {
        public MuleShutdownHook() {
            super("Mule.shutdown.hook");
        }

        @Override
        public void run() {
            MuleContainer.this.doShutdown();
        }
    }
}

