/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.beanutils.BeanPropertyValueEqualsPredicate;
import org.apache.commons.beanutils.BeanToPropertyValueTransformer;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleCoreExtension;
import org.mule.config.StartupContext;
import org.mule.config.i18n.MessageFactory;
import org.mule.module.launcher.AppDeployerMonitorThreadFactory;
import org.mule.module.launcher.DefaultMuleDeployer;
import org.mule.module.launcher.DeploymentException;
import org.mule.module.launcher.DeploymentListener;
import org.mule.module.launcher.DeploymentStatusTracker;
import org.mule.module.launcher.MuleDeployer;
import org.mule.module.launcher.StartupSummaryDeploymentListener;
import org.mule.module.launcher.application.Application;
import org.mule.module.launcher.application.ApplicationFactory;
import org.mule.module.launcher.util.DebuggableReentrantLock;
import org.mule.module.launcher.util.ElementAddedEvent;
import org.mule.module.launcher.util.ElementRemovedEvent;
import org.mule.module.launcher.util.ObservableList;
import org.mule.module.reboot.MuleContainerBootstrapUtils;
import org.mule.util.CollectionUtils;
import org.mule.util.FileUtils;
import org.mule.util.SplashScreen;
import org.mule.util.StringUtils;

public class DeploymentService {
    public static final String APP_ANCHOR_SUFFIX = "-anchor.txt";
    protected static final int DEFAULT_CHANGES_CHECK_INTERVAL_MS = 5000;
    protected ScheduledExecutorService appDirMonitorTimer;
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    protected MuleDeployer deployer;
    protected ApplicationFactory appFactory;
    private ReentrantLock lock = new DebuggableReentrantLock(true);
    private ObservableList<Application> applications = new ObservableList();
    private Map<URL, Long> zombieMap = new HashMap<URL, Long>();
    private List<StartupListener> startupListeners = new ArrayList<StartupListener>();
    private List<DeploymentListener> deploymentListeners = new CopyOnWriteArrayList<DeploymentListener>();

    public DeploymentService(Map<Class<? extends MuleCoreExtension>, MuleCoreExtension> coreExtensions) {
        this.deployer = new DefaultMuleDeployer(this);
        this.appFactory = new ApplicationFactory(this, coreExtensions);
    }

    /*
     * WARNING - void declaration
     */
    public void start() {
        Object[] apps;
        String[] appAnchors;
        Map options = StartupContext.get().getStartupOptions();
        String appString = (String)options.get("app");
        File appsDir = MuleContainerBootstrapUtils.getMuleAppsDir();
        for (String anchor : appAnchors = appsDir.list((FilenameFilter)new SuffixFileFilter(APP_ANCHOR_SUFFIX))) {
            new File(appsDir, anchor).delete();
        }
        boolean explicitAppSet = appString != null;
        DeploymentStatusTracker deploymentStatusTracker = new DeploymentStatusTracker();
        this.addDeploymentListener(deploymentStatusTracker);
        StartupSummaryDeploymentListener summaryDeploymentListener = new StartupSummaryDeploymentListener(deploymentStatusTracker);
        this.addStartupListener(summaryDeploymentListener);
        if (!explicitAppSet) {
            void var12_19;
            Object[] zips = appsDir.list((FilenameFilter)new SuffixFileFilter(".zip"));
            Arrays.sort(zips);
            Object[] arr$ = zips;
            int len$ = arr$.length;
            boolean bl = false;
            while (var12_19 < len$) {
                Object zip = arr$[var12_19];
                String appName = StringUtils.removeEnd((String)zip, (String)".zip");
                try {
                    this.deployer.installFromAppDir((String)zip);
                }
                catch (Throwable t) {
                    this.logger.error((Object)String.format("Failed to install app from archive '%s'", zip), t);
                    this.fireOnDeploymentFailure(appName, t);
                    File appZip = new File(appsDir, (String)zip);
                    this.addZombie(appZip);
                }
                ++var12_19;
            }
            apps = appsDir.list((FilenameFilter)DirectoryFileFilter.DIRECTORY);
            Arrays.sort(apps);
        } else {
            apps = appString.split(":");
        }
        for (String string : apps) {
            try {
                File appZip = new File(appsDir, string + ".zip");
                Application a = appZip.exists() ? this.deployer.installFromAppDir(appZip.getName()) : this.appFactory.createApp(string);
                this.applications.add(a);
            }
            catch (Throwable t) {
                this.fireOnDeploymentFailure(string, t);
                this.addZombie(new File(appsDir, string));
                this.logger.error((Object)String.format("Failed to create application [%s]", string), t);
            }
        }
        for (Application application : this.applications) {
            try {
                this.fireOnDeploymentStart(application.getAppName());
                this.deployer.deploy(application);
                this.fireOnDeploymentSuccess(application.getAppName());
            }
            catch (Throwable t) {
                this.fireOnDeploymentFailure(application.getAppName(), t);
                String string = SplashScreen.miniSplash((String)String.format("Failed to deploy app '%s', see below", application.getAppName()));
                this.logger.error((Object)string, t);
            }
        }
        for (StartupListener listener : this.startupListeners) {
            try {
                listener.onAfterStartup();
            }
            catch (Throwable t) {
                this.logger.error((Object)t);
            }
        }
        if (!explicitAppSet) {
            this.scheduleChangeMonitor(appsDir);
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)SplashScreen.miniSplash((String)"Mule is up and running in a fixed app set mode"));
        }
    }

    protected void scheduleChangeMonitor(File appsDir) {
        int reloadIntervalMs = 5000;
        this.appDirMonitorTimer = Executors.newSingleThreadScheduledExecutor(new AppDeployerMonitorThreadFactory());
        this.appDirMonitorTimer.scheduleWithFixedDelay(new AppDirWatcher(appsDir), 0L, 5000L, TimeUnit.MILLISECONDS);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)SplashScreen.miniSplash((String)String.format("Mule is up and kicking (every %dms)", 5000)));
        }
    }

    public void stop() {
        if (this.appDirMonitorTimer != null) {
            this.appDirMonitorTimer.shutdownNow();
        }
        Collections.reverse(this.applications);
        for (Application application : this.applications) {
            try {
                application.stop();
                application.dispose();
            }
            catch (Throwable t) {
                this.logger.error((Object)t);
            }
        }
    }

    public Application findApplication(String appName) {
        return (Application)CollectionUtils.find(this.applications, (Predicate)new BeanPropertyValueEqualsPredicate("appName", (Object)appName));
    }

    public List<Application> getApplications() {
        return Collections.unmodifiableList(this.applications);
    }

    public Map<URL, Long> getZombieMap() {
        return this.zombieMap;
    }

    protected MuleDeployer getDeployer() {
        return this.deployer;
    }

    public void setDeployer(MuleDeployer deployer) {
        this.deployer = deployer;
    }

    public ApplicationFactory getAppFactory() {
        return this.appFactory;
    }

    public ReentrantLock getLock() {
        return this.lock;
    }

    public void onApplicationInstalled(Application a) {
        this.applications.add(a);
    }

    protected void undeploy(Application app) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("================== Request to Undeploy Application: " + app.getAppName()));
        }
        this.applications.remove(app);
        this.deployer.undeploy(app);
    }

    public void undeploy(String appName) {
        Application app = (Application)CollectionUtils.find(this.applications, (Predicate)new BeanPropertyValueEqualsPredicate("appName", (Object)appName));
        this.undeploy(app);
    }

    public void deploy(URL appArchiveUrl) throws IOException {
        try {
            Application application = this.deployer.installFrom(appArchiveUrl);
            this.applications.add(application);
            this.deployer.deploy(application);
        }
        catch (Throwable t) {
            this.addZombie(FileUtils.toFile((URL)appArchiveUrl));
            if (t instanceof DeploymentException) {
                throw (DeploymentException)((Object)t);
            }
            String msg = "Failed to deploy from URL: " + appArchiveUrl;
            throw new DeploymentException(MessageFactory.createStaticMessage((String)msg), t);
        }
    }

    protected void addZombie(File marker) {
        if (marker == null) {
            return;
        }
        if (!marker.exists()) {
            return;
        }
        try {
            if (marker.isDirectory()) {
                File appConfig = new File(marker, "mule-config.xml");
                if (appConfig.exists()) {
                    long lastModified = appConfig.lastModified();
                    this.zombieMap.put(appConfig.toURI().toURL(), lastModified);
                }
            } else {
                long lastModified = marker.lastModified();
                this.zombieMap.put(marker.toURI().toURL(), lastModified);
            }
        }
        catch (MalformedURLException e) {
            this.logger.debug((Object)String.format("Failed to mark an exploded app [%s] as a zombie", marker.getName()), (Throwable)e);
        }
    }

    public void addStartupListener(StartupListener listener) {
        this.startupListeners.add(listener);
    }

    public void removeStartupListener(StartupListener listener) {
        this.startupListeners.remove(listener);
    }

    public void addDeploymentListener(DeploymentListener listener) {
        this.deploymentListeners.add(listener);
    }

    public void removeDeploymentListener(DeploymentListener listener) {
        this.deploymentListeners.remove(listener);
    }

    protected void fireOnDeploymentStart(String appName) {
        for (DeploymentListener listener : this.deploymentListeners) {
            try {
                listener.onDeploymentStart(appName);
            }
            catch (Throwable t) {
                this.logger.error((Object)"Listener failed to process onDeploymentStart notification", t);
            }
        }
    }

    protected void fireOnDeploymentSuccess(String appName) {
        for (DeploymentListener listener : this.deploymentListeners) {
            try {
                listener.onDeploymentSuccess(appName);
            }
            catch (Throwable t) {
                this.logger.error((Object)"Listener failed to process onDeploymentSuccess notification", t);
            }
        }
    }

    protected void fireOnDeploymentFailure(String appName, Throwable cause) {
        for (DeploymentListener listener : this.deploymentListeners) {
            try {
                listener.onDeploymentFailure(appName, cause);
            }
            catch (Throwable t) {
                this.logger.error((Object)"Listener failed to process onDeploymentFailure notification", t);
            }
        }
    }

    protected class AppDirWatcher
    implements Runnable {
        protected File appsDir;
        protected String[] appAnchors = new String[0];
        protected volatile boolean dirty;

        public AppDirWatcher(File appsDir) {
            this.appsDir = appsDir;
            DeploymentService.this.applications.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e instanceof ElementAddedEvent || e instanceof ElementRemovedEvent) {
                        if (DeploymentService.this.logger.isDebugEnabled()) {
                            DeploymentService.this.logger.debug((Object)"Deployed applications set has been modified, flushing state.");
                        }
                        AppDirWatcher.this.dirty = true;
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (DeploymentService.this.logger.isDebugEnabled()) {
                    DeploymentService.this.logger.debug((Object)"Checking for changes...");
                }
                if (!DeploymentService.this.lock.tryLock(0L, TimeUnit.SECONDS)) {
                    if (DeploymentService.this.logger.isDebugEnabled()) {
                        DeploymentService.this.logger.debug((Object)("Another deployment operation in progress, will skip this cycle. Owner thread: " + ((DebuggableReentrantLock)DeploymentService.this.lock).getOwner()));
                    }
                    return;
                }
                String[] zips = this.appsDir.list((FilenameFilter)new SuffixFileFilter(".zip"));
                String[] apps = this.appsDir.list((FilenameFilter)DirectoryFileFilter.DIRECTORY);
                String[] currentAnchors = this.appsDir.list((FilenameFilter)new SuffixFileFilter(DeploymentService.APP_ANCHOR_SUFFIX));
                if (DeploymentService.this.logger.isDebugEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(String.format("Current anchors:%n", new Object[0]));
                    for (String currentAnchor : currentAnchors) {
                        sb.append(String.format("  %s%n", currentAnchor));
                    }
                    DeploymentService.this.logger.debug((Object)sb.toString());
                }
                Collection deletedAnchors = CollectionUtils.subtract(Arrays.asList(this.appAnchors), Arrays.asList(currentAnchors));
                if (DeploymentService.this.logger.isDebugEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(String.format("Deleted anchors:%n", new Object[0]));
                    for (String deletedAnchor : deletedAnchors) {
                        sb.append(String.format("  %s%n", deletedAnchor));
                    }
                    DeploymentService.this.logger.debug((Object)sb.toString());
                }
                for (String deletedAnchor : deletedAnchors) {
                    String appName = StringUtils.removeEnd((String)deletedAnchor, (String)DeploymentService.APP_ANCHOR_SUFFIX);
                    try {
                        if (DeploymentService.this.findApplication(appName) != null) {
                            DeploymentService.this.undeploy(appName);
                            continue;
                        }
                        if (!DeploymentService.this.logger.isDebugEnabled()) continue;
                        DeploymentService.this.logger.debug((Object)String.format("Application [%s] has already been undeployed via API", appName));
                    }
                    catch (Throwable t) {
                        DeploymentService.this.logger.error((Object)("Failed to undeploy application: " + appName), t);
                    }
                }
                this.appAnchors = currentAnchors;
                for (String zip : zips) {
                    File appZip = null;
                    try {
                        String appName = StringUtils.removeEnd((String)zip, (String)".zip");
                        Application app = (Application)CollectionUtils.find((Collection)DeploymentService.this.applications, (Predicate)new BeanPropertyValueEqualsPredicate("appName", (Object)appName));
                        if (app != null) {
                            DeploymentService.this.undeploy(appName);
                        }
                        appZip = new File(this.appsDir, zip);
                        URL url = appZip.toURI().toURL();
                        if (this.isZombieApplication(appZip)) continue;
                        DeploymentService.this.deploy(url);
                    }
                    catch (Throwable t) {
                        DeploymentService.this.logger.error((Object)("Failed to deploy application archive: " + zip), t);
                        DeploymentService.this.addZombie(appZip);
                    }
                }
                if (zips.length > 0 || this.dirty) {
                    apps = this.appsDir.list((FilenameFilter)DirectoryFileFilter.DIRECTORY);
                }
                Collection deployedAppNames = CollectionUtils.collect((Collection)DeploymentService.this.applications, (Transformer)new BeanToPropertyValueTransformer("appName"));
                Collection addedApps = CollectionUtils.subtract(Arrays.asList(apps), (Collection)deployedAppNames);
                for (String addedApp : addedApps) {
                    File appDir = new File(this.appsDir, addedApp);
                    if (this.isZombieApplication(appDir)) continue;
                    try {
                        this.onNewExplodedApplication(addedApp);
                    }
                    catch (Throwable t) {
                        DeploymentService.this.addZombie(appDir);
                        DeploymentService.this.logger.error((Object)("Failed to deploy exploded application: " + addedApp), t);
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                if (DeploymentService.this.lock.isHeldByCurrentThread()) {
                    DeploymentService.this.lock.unlock();
                }
                this.dirty = false;
            }
        }

        protected boolean isZombieApplication(File marker) {
            long newTimeStamp;
            long originalTimeStamp;
            URL url;
            if (!marker.exists()) {
                return false;
            }
            try {
                url = marker.isDirectory() ? new File(marker, "mule-config.xml").toURI().toURL() : marker.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            boolean result = false;
            if (DeploymentService.this.zombieMap.containsKey(url) && (originalTimeStamp = ((Long)DeploymentService.this.zombieMap.get(url)).longValue()) == (newTimeStamp = FileUtils.getFileTimeStamp((URL)url))) {
                result = true;
            }
            return result;
        }

        protected void onNewExplodedApplication(String appName) throws Exception {
            if (DeploymentService.this.logger.isInfoEnabled()) {
                DeploymentService.this.logger.info((Object)("================== New Exploded Application: " + appName));
            }
            Application a = DeploymentService.this.appFactory.createApp(appName);
            DeploymentService.this.onApplicationInstalled(a);
            DeploymentService.this.deployer.deploy(a);
        }
    }

    public static interface StartupListener {
        public void onAfterStartup();
    }
}

