/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher.descriptor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.lang.BooleanUtils;
import org.mule.module.launcher.descriptor.ApplicationDescriptor;
import org.mule.module.launcher.descriptor.DescriptorParser;
import org.mule.util.PropertiesUtils;
import org.mule.util.StringUtils;

public class PropertiesDescriptorParser
implements DescriptorParser {
    protected static final String PROPERTY_ENCODING = "encoding";
    protected static final String PROPERTY_CONFIG_BUILDER = "config.builder";
    protected static final String PROPERTY_DOMAIN = "domain";
    protected static final String PROPERTY_CLASSLOADER_PARENT_FIRST = "classloader.parentFirst";
    protected static final String PROPERTY_CONFIG_RESOURCES = "config.resources";
    protected static final String PROPERTY_REDEPLOYMENT_ENABLED = "redeployment.enabled";
    protected static final String PROPERTY_PRIVILEDGED = "priviledged";

    public ApplicationDescriptor parse(File descriptor) throws IOException {
        Properties p = new Properties();
        p.load(new FileInputStream(descriptor));
        ApplicationDescriptor d = new ApplicationDescriptor();
        d.setEncoding(p.getProperty(PROPERTY_ENCODING));
        d.setConfigurationBuilder(p.getProperty(PROPERTY_CONFIG_BUILDER));
        d.setDomain(p.getProperty(PROPERTY_DOMAIN));
        File appPropsFile = new File(descriptor.getParent(), "mule-app.properties");
        if (appPropsFile.exists() && appPropsFile.canRead()) {
            Properties props = PropertiesUtils.loadProperties((URL)appPropsFile.toURI().toURL());
            HashMap<String, String> m = new HashMap<String, String>(props.size());
            for (String key : m.keySet()) {
                m.put(key, props.getProperty(key));
            }
            d.setAppProperties(m);
        }
        d.setParentFirstClassLoader(BooleanUtils.toBoolean((String)p.getProperty(PROPERTY_CLASSLOADER_PARENT_FIRST, Boolean.TRUE.toString())));
        String resProps = p.getProperty(PROPERTY_CONFIG_RESOURCES);
        String[] urls = StringUtils.isBlank((String)resProps) ? new String[]{"mule-config.xml"} : resProps.split(",");
        d.setConfigResources(urls);
        d.setRedeploymentEnabled(BooleanUtils.toBoolean((String)p.getProperty(PROPERTY_REDEPLOYMENT_ENABLED, Boolean.TRUE.toString())));
        d.setPriviledged(BooleanUtils.toBoolean((String)p.getProperty(PROPERTY_PRIVILEDGED, Boolean.FALSE.toString())));
        return d;
    }

    public String getSupportedFormat() {
        return "properties";
    }
}

