/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher;

import java.beans.Introspector;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.module.launcher.DeploymentService;
import org.mule.module.launcher.MuleDeployer;
import org.mule.module.launcher.application.Application;
import org.mule.module.reboot.MuleContainerBootstrapUtils;
import org.mule.util.FileUtils;
import org.mule.util.FilenameUtils;

public class DefaultMuleDeployer
implements MuleDeployer {
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    protected DeploymentService deploymentService;

    public DefaultMuleDeployer(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(Application app) {
        ReentrantLock lock = this.deploymentService.getLock();
        try {
            if (!lock.tryLock(0L, TimeUnit.SECONDS)) {
                return;
            }
            app.install();
            app.init();
            app.start();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(Application app) {
        ReentrantLock lock = this.deploymentService.getLock();
        try {
            if (!lock.tryLock(0L, TimeUnit.SECONDS)) {
                return;
            }
            app.stop();
            app.dispose();
            File appDir = new File(MuleContainerBootstrapUtils.getMuleAppsDir(), app.getAppName());
            FileUtils.deleteDirectory((File)appDir);
            File marker = new File(MuleContainerBootstrapUtils.getMuleAppsDir(), String.format("%s-anchor.txt", app.getAppName()));
            marker.delete();
            Introspector.flushCaches();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
    }

    public Application installFromAppDir(String packedMuleAppFileName) throws IOException {
        ReentrantLock lock = this.deploymentService.getLock();
        try {
            if (!lock.tryLock(0L, TimeUnit.SECONDS)) {
                throw new IOException("Another deployment operation is in progress");
            }
            File appsDir = MuleContainerBootstrapUtils.getMuleAppsDir();
            File appFile = new File(appsDir, packedMuleAppFileName);
            if (!appFile.getParentFile().equals(appsDir)) {
                throw new SecurityException("installFromAppDir() can only deploy from $MULE_HOME/apps. Use installFrom(url) instead.");
            }
            Application application = this.installFrom(appFile.toURL());
            return application;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Install operation has been interrupted");
        }
        finally {
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
    }

    public Application installFrom(URL url) throws IOException {
        String appName;
        if (!url.toString().endsWith(".zip")) {
            throw new IllegalArgumentException("Only Mule application zips are supported: " + url);
        }
        ReentrantLock lock = this.deploymentService.getLock();
        try {
            if (!lock.tryLock(0L, TimeUnit.SECONDS)) {
                throw new IOException("Another deployment operation is in progress");
            }
            File appsDir = MuleContainerBootstrapUtils.getMuleAppsDir();
            String fullPath = url.toURI().toString();
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Exploding a Mule application archive: " + fullPath));
            }
            appName = FilenameUtils.getBaseName((String)fullPath);
            File appDir = new File(appsDir, appName);
            File source = new File(url.toURI());
            FileUtils.unzip((File)source, (File)appDir);
            if ("file".equals(url.getProtocol())) {
                FileUtils.deleteQuietly((File)source);
            }
        }
        catch (URISyntaxException e) {
            IOException ex = new IOException(e.getMessage());
            ex.fillInStackTrace();
            throw ex;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Install operation has been interrupted");
        }
        finally {
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
        return this.deploymentService.getAppFactory().createApp(appName);
    }
}

