/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.transformers;

import de.odysseus.staxon.json.JsonXMLInputFactory;
import de.odysseus.staxon.json.JsonXMLOutputFactory;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URL;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stax.StAXSource;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.module.json.transformers.TransformerInputs;
import org.mule.module.xml.transformer.XsltTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.IOUtils;
import org.mule.util.xmlsecurity.XMLSecureFactories;

public class JsonXsltTransformer
extends XsltTransformer {
    public JsonXsltTransformer() {
        this.registerSourceType(DataTypeFactory.STRING);
        this.registerSourceType(DataTypeFactory.INPUT_STREAM);
        this.registerSourceType(DataTypeFactory.BYTE_ARRAY);
        this.registerSourceType(DataTypeFactory.create(Reader.class));
        this.registerSourceType(DataTypeFactory.create(URL.class));
        this.registerSourceType(DataTypeFactory.create(File.class));
        this.setReturnDataType(DataTypeFactory.XML_STRING);
    }

    public Object transformMessage(MuleMessage message, String enc) throws TransformerException {
        JsonXMLInputFactory inputFactory = new JsonXMLInputFactory();
        inputFactory.setProperty("JsonXMLInputFactory.multiplePI", false);
        TransformerInputs inputs = new TransformerInputs((Transformer)this, message.getPayload());
        try {
            StAXSource source = inputs.getInputStream() != null ? new StAXSource(inputFactory.createXMLStreamReader(inputs.getInputStream(), enc == null ? "UTF-8" : enc)) : new StAXSource(inputFactory.createXMLStreamReader(inputs.getReader()));
            JsonXMLOutputFactory outputFactory = new JsonXMLOutputFactory();
            outputFactory.setProperty("JsonXMLOutputFactory.autoArray", true);
            outputFactory.setProperty("JsonXMLOutputFactory.prettyPrint", true);
            StringWriter writer = new StringWriter();
            XMLStreamWriter output = outputFactory.createXMLStreamWriter(writer);
            StAXResult result = new StAXResult(output);
            this.doTransform(message, enc, source, result);
            String string = writer.toString();
            return string;
        }
        catch (Exception ex) {
            throw new TransformerException((Transformer)this, (Throwable)ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputs.getInputStream());
            IOUtils.closeQuietly((Reader)inputs.getReader());
        }
    }

    public TransformerFactory getTransformerFactory() {
        return XMLSecureFactories.createDefault().getTransformerFactory();
    }
}

