/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import com.google.common.base.Joiner;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import org.mule.api.MuleContext;
import org.mule.api.transformer.DataType;
import org.mule.module.json.JsonData;
import org.mule.module.json.JsonParser;
import org.mule.transformer.TransformerUtils;
import org.mule.transformer.types.DataTypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultJsonParser
implements JsonParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultJsonParser.class);
    private static final DataType<?>[] TRANSFORMABLE_SUPPORTED_TYPES = new DataType[]{DataTypeFactory.create(JsonData.class), DataTypeFactory.create(JsonNode.class), DataTypeFactory.create(String.class)};
    private static final String TRANSFORMABLE_SUPPORTED_TYPES_AS_STRING = Joiner.on((char)',').join((Object[])TRANSFORMABLE_SUPPORTED_TYPES);
    private final MuleContext muleContext;

    public DefaultJsonParser(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    @Override
    public JsonNode asJsonNode(Object input) throws IOException {
        JsonNode jsonNode = this.toJsonNode(input);
        if (jsonNode == null) {
            LOGGER.debug("Input type {} was not of any supported type. Attempting with transformer resolution of the following types {}", (Object)input.getClass().getName(), (Object)TRANSFORMABLE_SUPPORTED_TYPES_AS_STRING);
            input = TransformerUtils.transformToAny((Object)input, (MuleContext)this.muleContext, TRANSFORMABLE_SUPPORTED_TYPES);
            jsonNode = this.asJsonNode(input);
            if (jsonNode == null) {
                LOGGER.debug("Could not transform input of type {} to any supported type. Returning null", (Object)input.getClass().getName());
            }
        }
        return jsonNode;
    }

    private JsonNode toJsonNode(Object input) throws IOException {
        if (input instanceof String) {
            return JsonLoader.fromString((String)((String)input));
        }
        if (input instanceof Reader) {
            return JsonLoader.fromReader((Reader)((Reader)input));
        }
        if (input instanceof InputStream) {
            return JsonLoader.fromReader((Reader)new InputStreamReader((InputStream)input));
        }
        if (input instanceof byte[]) {
            return JsonLoader.fromReader((Reader)new InputStreamReader(new ByteArrayInputStream((byte[])input)));
        }
        if (input instanceof JsonNode) {
            return (JsonNode)input;
        }
        if (input instanceof JsonData) {
            JsonData jsonData = (JsonData)input;
            return JsonLoader.fromReader((Reader)new StringReader(jsonData.toString()));
        }
        return null;
    }
}

