/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.transformers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.module.json.transformers.AbstractJsonTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectToJson
extends AbstractJsonTransformer {
    protected final transient Log logger = LogFactory.getLog(ObjectToJson.class);
    private Map<Class, Class> serializationMixins = new HashMap<Class, Class>();
    protected Class sourceClass;
    private boolean handleException = false;

    public ObjectToJson() {
        this.registerSourceType(Object.class);
        this.setReturnClass(String.class);
    }

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        if (this.getSourceClass() != null) {
            this.sourceTypes.clear();
            this.registerSourceType(this.getSourceClass());
        }
        for (Map.Entry<Class, Class> entry : this.getMixins().entrySet()) {
            this.getMapper().getSerializationConfig().addMixInAnnotations(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Class, Class> entry : this.serializationMixins.entrySet()) {
            this.getMapper().getSerializationConfig().addMixInAnnotations(entry.getKey(), entry.getValue());
        }
    }

    public Object transform(MuleMessage message, String encoding) throws TransformerException {
        Object src = message.getPayload();
        if (message.getExceptionPayload() != null && this.isHandleException()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Found exception with null payload");
            }
            src = this.getException(message.getExceptionPayload().getException());
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.getMapper().writeValue((OutputStream)baos, src);
        }
        catch (IOException e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
        System.out.println(baos.toString());
        if (this.returnClass.equals(byte[].class)) {
            return baos.toByteArray();
        }
        return baos.toString();
    }

    private Exception getException(Throwable t) {
        Exception returnValue = null;
        ArrayList<Throwable> causeStack = new ArrayList<Throwable>();
        for (Throwable tempCause = t; tempCause != null; tempCause = tempCause.getCause()) {
            causeStack.add(tempCause);
        }
        for (int i = causeStack.size() - 1; i >= 0; --i) {
            Throwable tempCause = (Throwable)causeStack.get(i);
            if (i == causeStack.size()) {
                returnValue = new Exception(tempCause.getMessage());
                returnValue.setStackTrace(tempCause.getStackTrace());
                continue;
            }
            returnValue = new Exception(tempCause.getMessage(), returnValue);
            returnValue.setStackTrace(tempCause.getStackTrace());
        }
        return returnValue;
    }

    public boolean isHandleException() {
        return this.handleException;
    }

    public void setHandleException(boolean handleException) {
        this.handleException = handleException;
    }

    public Class getSourceClass() {
        return this.sourceClass;
    }

    public void setSourceClass(Class sourceClass) {
        this.sourceClass = sourceClass;
    }

    public Map<Class, Class> getSerializationMixins() {
        return this.serializationMixins;
    }

    public void setSerializationMixins(Map<Class, Class> serializationMixins) {
        this.serializationMixins = serializationMixins;
    }
}

