/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.mule.util.NumberUtils;

public class JsonData
implements Serializable {
    private JsonNode node;

    public JsonData(JsonNode node) {
        this.node = node;
    }

    public JsonData(URL node) throws IOException {
        this(node.openStream());
    }

    public JsonData(InputStream node) throws IOException {
        this.node = new ObjectMapper().readTree(node);
    }

    public JsonData(Reader node) throws IOException {
        this.node = new ObjectMapper().readTree(node);
    }

    public JsonData(String node) throws IOException {
        this(new StringReader(node));
    }

    public boolean equals(Object obj) {
        return this.node.equals(obj);
    }

    public JsonNode get(int index) {
        return this.node.get(index);
    }

    public boolean isArray() {
        return this.node.isArray();
    }

    public Object get(String name) {
        JsonNode o;
        String key = null;
        int index = -1;
        int x = name.indexOf("[");
        int y = -1;
        if (x >= 0 && NumberUtils.isDigits((String)(key = name.substring(x + 1, y = name.indexOf("]"))))) {
            index = Integer.valueOf(key);
            key = null;
        }
        int offset = 0;
        if (name.startsWith("'")) {
            offset = name.indexOf("'", 1);
        }
        int i = name.indexOf("/", offset);
        String objectName = x > 0 ? name.substring(0, x) : (i > 0 ? name.substring(0, i) : name);
        if (this.isArray() && !objectName.startsWith("[")) {
            throw new IllegalArgumentException("Object is an array, but a name of the object is given: " + objectName);
        }
        if (objectName.startsWith("'")) {
            objectName = objectName.substring(1, objectName.length() - 1);
        }
        if ((o = key != null ? null : (index > -1 && !objectName.startsWith("[") ? this.node.get(objectName).get(index) : (index > -1 ? this.node.get(index) : this.node.get(objectName)))) == null) {
            throw new IllegalArgumentException(objectName + " does not exist");
        }
        if (!o.isValueNode() && i > 0) {
            return new JsonData(o).get(name.substring(i + 1));
        }
        if (!o.isValueNode() && y > 0) {
            return new JsonData(o).get(name.substring(y + 1));
        }
        return o.getValueAsText();
    }

    public String toString() {
        return this.node.toString();
    }
}

