/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jersey;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import org.apache.commons.httpclient.Cookie;
import org.glassfish.jersey.internal.MapPropertiesDelegate;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.jackson1.Jackson1Feature;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.ServerRuntime;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;
import org.glassfish.jersey.server.spi.ResponseErrorMapper;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.component.JavaComponent;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.OutputHandler;
import org.mule.component.AbstractComponent;
import org.mule.component.BindingUtils;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.jersey.MuleResponseWriter;
import org.mule.module.jersey.exception.FallbackErrorMapper;
import org.mule.util.ClassUtils;

public class JerseyResourcesComponent
extends AbstractComponent {
    protected static final String JERSEY_RESPONSE = "jersey_response";
    private static final SecurityContext DEFAULT_SECURITY_CONTEXT = new SecurityContext(){

        public boolean isUserInRole(String role) {
            return false;
        }

        public boolean isSecure() {
            return false;
        }

        public Principal getUserPrincipal() {
            return null;
        }

        public String getAuthenticationScheme() {
            return null;
        }
    };
    private List<JavaComponent> components;
    private ScheduledExecutorService backgroundScheduler;
    private List<ExceptionMapper<?>> exceptionMappers = new ArrayList();
    private List<ContextResolver<?>> contextResolvers = new ArrayList();
    private Set<String> packages = new HashSet<String>();
    private Map<String, Object> properties = new HashMap<String, Object>();
    private ApplicationHandler application;
    private ResourceConfig resourceConfig;

    protected void doInitialise() throws InitialisationException {
        super.doInitialise();
        HashSet resources = new HashSet();
        if (this.components == null) {
            throw new IllegalStateException("There must be at least one component in the Jersey resources.");
        }
        this.initializeOtherResources(this.exceptionMappers, resources);
        this.initializeOtherResources(this.contextResolvers, resources);
        try {
            this.application = this.createApplication(resources);
            ServerRuntime serverRuntime = (ServerRuntime)ClassUtils.getFieldValue((Object)this.application, (String)"runtime", (boolean)false);
            this.backgroundScheduler = (ScheduledExecutorService)ClassUtils.getFieldValue((Object)serverRuntime, (String)"backgroundScheduler", (boolean)false);
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    protected void initializeResources(ResourceConfig config) throws Exception {
        for (JavaComponent component : this.components) {
            Object resource = component.getObjectFactory().getInstance(this.muleContext);
            BindingUtils.configureBinding((JavaComponent)component, (Object)resource);
            config.register(resource);
        }
    }

    protected void initializeOtherResources(List<?> newResources, Set<Class<?>> resources) {
        for (Object resource : newResources) {
            resources.add(resource.getClass());
        }
    }

    protected ApplicationHandler createApplication(Set<Class<?>> resources) throws Exception {
        if (!this.properties.containsKey("jersey.config.server.exception.processResponseErrors")) {
            this.properties.put("jersey.config.server.exception.processResponseErrors", true);
        }
        this.resourceConfig = new ResourceConfig();
        this.initializeResources(this.resourceConfig);
        for (String pkg : this.packages) {
            this.resourceConfig.packages(new String[]{pkg});
        }
        this.resourceConfig.addProperties(this.properties).registerClasses(resources).register(Jackson1Feature.class);
        if (!this.resourceConfig.isRegistered(ResponseErrorMapper.class)) {
            this.resourceConfig.register((Object)new FallbackErrorMapper());
        }
        return new ApplicationHandler((Application)this.resourceConfig);
    }

    protected Object doInvoke(MuleEvent event) throws Exception {
        ContainerRequest req = this.buildRequest(event);
        req.setSecurityContext(DEFAULT_SECURITY_CONTEXT);
        MuleMessage message = event.getMessage();
        req.setEntityStream(this.getInputStream(message));
        this.copyProperties(message, req);
        return this.execute(req, event);
    }

    private Object execute(ContainerRequest request, MuleEvent event) {
        final MuleResponseWriter writer = new MuleResponseWriter(event, request.getMethod(), this.backgroundScheduler);
        request.setWriter((ContainerResponseWriter)writer);
        this.application.handle(request);
        return new OutputHandler(){

            public void write(MuleEvent event, OutputStream out) throws IOException {
                writer.getOutputStream().setDelegate(out);
            }
        };
    }

    protected void copyProperties(MuleMessage message, ContainerRequest request) {
        for (Object prop : message.getInboundPropertyNames()) {
            if ("cookies".equals(prop) || "Cookie".equals(prop)) {
                Object cookies = message.getInboundProperty("cookies");
                if (cookies instanceof Cookie[]) {
                    for (Cookie apacheCookie : (Cookie[])cookies) {
                        javax.ws.rs.core.Cookie cookie = new javax.ws.rs.core.Cookie(apacheCookie.getName(), apacheCookie.getValue());
                        request.header("Cookie", (Object)cookie);
                    }
                    continue;
                }
                this.addHeader(request, prop, cookies);
                continue;
            }
            this.addHeader(request, prop, message.getInboundProperty(prop.toString()));
        }
    }

    private void addHeader(ContainerRequest request, Object prop, Object property) {
        if (property != null) {
            request.header(prop.toString(), (Object)property.toString());
        }
    }

    private InputStream getInputStream(MuleMessage message) throws TransformerException {
        return (InputStream)message.getPayload(InputStream.class);
    }

    private ContainerRequest buildRequest(MuleEvent event) throws URISyntaxException {
        MuleMessage message = event.getMessage();
        String path = this.resolvePath(message);
        String contextPath = this.resolveContextPath(message);
        String query = null;
        int queryIdx = path.indexOf(63);
        if (queryIdx != -1) {
            query = path.substring(queryIdx + 1);
            path = path.substring(0, queryIdx);
        }
        String host = (String)message.getInboundProperty("Host", (Object)event.getMessageSourceURI().getHost());
        String method = (String)message.getInboundProperty("http.method");
        String scheme = this.resolveScheme(event);
        URI baseUri = this.getBaseUri(scheme, host, contextPath);
        URI completeUri = this.getCompleteUri(scheme, host, path, query);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Base URI: " + baseUri));
            this.logger.debug((Object)("Complete URI: " + completeUri));
        }
        return new ContainerRequest(baseUri, completeUri, method, null, (PropertiesDelegate)new MapPropertiesDelegate());
    }

    private String resolvePath(MuleMessage message) {
        String path = (String)message.getInboundProperty("http.request");
        if (path == null) {
            path = (String)message.getInboundProperty("http.request.uri");
        }
        return path;
    }

    private String resolveContextPath(MuleMessage message) {
        String contextPath = (String)message.getInboundProperty("http.context.path");
        if (contextPath == null && (contextPath = (String)message.getInboundProperty("http.listener.path")) != null && contextPath.endsWith("*")) {
            contextPath = contextPath.substring(0, contextPath.length() - 1);
        }
        return contextPath;
    }

    private String resolveScheme(MuleEvent event) {
        String scheme = event.getMessageSourceURI().getScheme();
        if (scheme == null) {
            scheme = (String)event.getMessage().getInboundProperty("http.scheme");
        }
        if ("servlet".equals(scheme)) {
            scheme = HttpConstants.Protocols.HTTP.getScheme();
        }
        return scheme;
    }

    private URI getCompleteUri(String scheme, String host, String path, String query) throws URISyntaxException {
        String uri = scheme + "://" + host + path;
        if (query != null) {
            uri = uri + "?" + query;
        }
        return new URI(uri);
    }

    private URI getBaseUri(String scheme, String host, String contextPath) throws URISyntaxException {
        if (!contextPath.endsWith("/")) {
            contextPath = contextPath + "/";
        }
        return new URI(scheme + "://" + host + contextPath);
    }

    public List<JavaComponent> getComponents() {
        return this.components;
    }

    public void setComponents(List<JavaComponent> components) {
        this.components = components;
    }

    public void setMessageProcessors(List<MessageProcessor> messageProcessors) {
        ArrayList<JavaComponent> javaComponents = new ArrayList<JavaComponent>();
        for (MessageProcessor mp : messageProcessors) {
            if (mp instanceof JavaComponent) {
                javaComponents.add((JavaComponent)mp);
                continue;
            }
            throw new IllegalStateException("Only JavaComponents are allowed as MessageProcessors. Type " + mp.getClass().getName() + " is not allowed.");
        }
        this.setComponents(javaComponents);
    }

    protected ResourceConfig getResourceConfig() {
        return this.resourceConfig;
    }

    public void setExceptionMappers(List<ExceptionMapper<?>> exceptionMappers) {
        this.exceptionMappers.addAll(exceptionMappers);
    }

    public void setContextResolvers(List<ContextResolver<?>> contextResolvers) {
        this.contextResolvers.addAll(contextResolvers);
    }

    public void setPackages(Set<String> packages) {
        this.packages = packages;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }
}

